/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.fdf;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDRange;

public class FDFIconFit
implements COSObjectable {
    private COSDictionary fit;
    public static final String SCALE_OPTION_ALWAYS = "A";
    public static final String SCALE_OPTION_ONLY_WHEN_ICON_IS_BIGGER = "B";
    public static final String SCALE_OPTION_ONLY_WHEN_ICON_IS_SMALLER = "S";
    public static final String SCALE_OPTION_NEVER = "N";
    public static final String SCALE_TYPE_ANAMORPHIC = "A";
    public static final String SCALE_TYPE_PROPORTIONAL = "P";

    public FDFIconFit() {
        this.fit = new COSDictionary();
    }

    public FDFIconFit(COSDictionary f) {
        this.fit = f;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.fit;
    }

    public String getScaleOption() {
        String retval = this.fit.getNameAsString(COSName.SW);
        if (retval == null) {
            retval = "A";
        }
        return retval;
    }

    public void setScaleOption(String option) {
        this.fit.setName(COSName.SW, option);
    }

    public String getScaleType() {
        String retval = this.fit.getNameAsString(COSName.S);
        if (retval == null) {
            retval = SCALE_TYPE_PROPORTIONAL;
        }
        return retval;
    }

    public void setScaleType(String scale) {
        this.fit.setName(COSName.S, scale);
    }

    public PDRange getFractionalSpaceToAllocate() {
        PDRange retval = null;
        COSArray array = (COSArray)this.fit.getDictionaryObject(COSName.A);
        if (array == null) {
            retval = new PDRange();
            retval.setMin(0.5f);
            retval.setMax(0.5f);
            this.setFractionalSpaceToAllocate(retval);
        } else {
            retval = new PDRange(array);
        }
        return retval;
    }

    public void setFractionalSpaceToAllocate(PDRange space) {
        this.fit.setItem(COSName.A, (COSObjectable)space);
    }

    public boolean shouldScaleToFitAnnotation() {
        return this.fit.getBoolean(COSName.FB, false);
    }

    public void setScaleToFitAnnotation(boolean value) {
        this.fit.setBoolean(COSName.FB, value);
    }
}

