/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.common.filespecification;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Calendar;

public class PDEmbeddedFile
extends PDStream {
    public PDEmbeddedFile(PDDocument document) {
        super(document);
        this.getStream().setName(COSName.TYPE, "EmbeddedFile");
    }

    public PDEmbeddedFile(COSStream str) {
        super(str);
    }

    public PDEmbeddedFile(PDDocument doc, InputStream str) throws IOException {
        super(doc, str);
        this.getStream().setName(COSName.TYPE, "EmbeddedFile");
    }

    public void setSubtype(String mimeType) {
        this.getStream().setName(COSName.SUBTYPE, mimeType);
    }

    public String getSubtype() {
        return this.getStream().getNameAsString(COSName.SUBTYPE);
    }

    public int getSize() {
        return this.getStream().getEmbeddedInt("Params", "Size");
    }

    public void setSize(int size) {
        this.getStream().setEmbeddedInt("Params", "Size", size);
    }

    public Calendar getCreationDate() throws IOException {
        return this.getStream().getEmbeddedDate("Params", "CreationDate");
    }

    public void setCreationDate(Calendar creation) {
        this.getStream().setEmbeddedDate("Params", "CreationDate", creation);
    }

    public Calendar getModDate() throws IOException {
        return this.getStream().getEmbeddedDate("Params", "ModDate");
    }

    public void setModDate(Calendar mod) {
        this.getStream().setEmbeddedDate("Params", "ModDate", mod);
    }

    public String getCheckSum() {
        return this.getStream().getEmbeddedString("Params", "CheckSum");
    }

    public void setCheckSum(String checksum) {
        this.getStream().setEmbeddedString("Params", "CheckSum", checksum);
    }

    public String getMacSubtype() {
        String retval = null;
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params != null) {
            retval = params.getEmbeddedString("Mac", "Subtype");
        }
        return retval;
    }

    public void setMacSubtype(String macSubtype) {
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params == null && macSubtype != null) {
            params = new COSDictionary();
            this.getStream().setItem(COSName.PARAMS, (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString("Mac", "Subtype", macSubtype);
        }
    }

    public String getMacCreator() {
        String retval = null;
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params != null) {
            retval = params.getEmbeddedString("Mac", "Creator");
        }
        return retval;
    }

    public void setMacCreator(String macCreator) {
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params == null && macCreator != null) {
            params = new COSDictionary();
            this.getStream().setItem(COSName.PARAMS, (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString("Mac", "Creator", macCreator);
        }
    }

    public String getMacResFork() {
        String retval = null;
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params != null) {
            retval = params.getEmbeddedString("Mac", "ResFork");
        }
        return retval;
    }

    public void setMacResFork(String macResFork) {
        COSDictionary params = (COSDictionary)this.getStream().getDictionaryObject(COSName.PARAMS);
        if (params == null && macResFork != null) {
            params = new COSDictionary();
            this.getStream().setItem(COSName.PARAMS, (COSBase)params);
        }
        if (params != null) {
            params.setEmbeddedString("Mac", "ResFork", macResFork);
        }
    }
}

