/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.common;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSInputStream;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.cos.COSString;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class PDTextStream
implements COSObjectable {
    private COSString string;
    private COSStream stream;

    public PDTextStream(COSString str) {
        this.string = str;
    }

    public PDTextStream(String str) {
        this.string = new COSString(str);
    }

    public PDTextStream(COSStream str) {
        this.stream = str;
    }

    public static PDTextStream createTextStream(COSBase base) {
        PDTextStream retval = null;
        if (base instanceof COSString) {
            retval = new PDTextStream((COSString)base);
        } else if (base instanceof COSStream) {
            retval = new PDTextStream((COSStream)base);
        }
        return retval;
    }

    @Override
    public COSBase getCOSObject() {
        return this.string == null ? this.stream : this.string;
    }

    public String getAsString() throws IOException {
        if (this.string != null) {
            return this.string.getString();
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        COSInputStream is = this.stream.createInputStream();
        IOUtils.copy(is, out);
        IOUtils.closeQuietly(is);
        return new String(out.toByteArray(), "ISO-8859-1");
    }

    public InputStream getAsStream() throws IOException {
        InputStream retval = this.string != null ? new ByteArrayInputStream(this.string.getBytes()) : this.stream.createInputStream();
        return retval;
    }
}

