/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.common;

import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSInteger;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDNumberTreeNode;
import com.tom_roush.pdfbox.pdmodel.common.PDPageLabelRange;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;

public class PDPageLabels
implements COSObjectable {
    private Map<Integer, PDPageLabelRange> labels = new TreeMap<Integer, PDPageLabelRange>();
    private PDDocument doc;

    public PDPageLabels(PDDocument document) {
        this.doc = document;
        PDPageLabelRange defaultRange = new PDPageLabelRange();
        defaultRange.setStyle("D");
        this.labels.put(0, defaultRange);
    }

    public PDPageLabels(PDDocument document, COSDictionary dict) throws IOException {
        this(document);
        if (dict == null) {
            return;
        }
        PDNumberTreeNode root = new PDNumberTreeNode(dict, COSDictionary.class);
        this.findLabels(root);
    }

    private void findLabels(PDNumberTreeNode node) throws IOException {
        block3: {
            block2: {
                if (node.getKids() == null) break block2;
                List<PDNumberTreeNode> kids = node.getKids();
                for (PDNumberTreeNode kid : kids) {
                    this.findLabels(kid);
                }
                break block3;
            }
            if (node.getNumbers() == null) break block3;
            Map<Integer, COSObjectable> numbers = node.getNumbers();
            for (Map.Entry<Integer, COSObjectable> i : numbers.entrySet()) {
                if (i.getKey() < 0) continue;
                this.labels.put(i.getKey(), new PDPageLabelRange((COSDictionary)i.getValue()));
            }
        }
    }

    public int getPageRangeCount() {
        return this.labels.size();
    }

    public PDPageLabelRange getPageLabelRange(int startPage) {
        return this.labels.get(startPage);
    }

    public void setLabelItem(int startPage, PDPageLabelRange item) {
        if (startPage < 0) {
            throw new IllegalArgumentException("startPage parameter of setLabelItem may not be < 0");
        }
        this.labels.put(startPage, item);
    }

    @Override
    public COSBase getCOSObject() {
        COSDictionary dict = new COSDictionary();
        COSArray arr = new COSArray();
        for (Map.Entry<Integer, PDPageLabelRange> i : this.labels.entrySet()) {
            arr.add(COSInteger.get(i.getKey().intValue()));
            arr.add(i.getValue());
        }
        dict.setItem(COSName.NUMS, (COSBase)arr);
        return dict;
    }

    public Map<String, Integer> getPageIndicesByLabels() {
        final HashMap<String, Integer> labelMap = new HashMap<String, Integer>(this.doc.getNumberOfPages());
        this.computeLabels(new LabelHandler(){

            @Override
            public void newLabel(int pageIndex, String label) {
                labelMap.put(label, pageIndex);
            }
        });
        return labelMap;
    }

    public String[] getLabelsByPageIndices() {
        final String[] map = new String[this.doc.getNumberOfPages()];
        this.computeLabels(new LabelHandler(){

            @Override
            public void newLabel(int pageIndex, String label) {
                if (pageIndex < PDPageLabels.this.doc.getNumberOfPages()) {
                    map[pageIndex] = label;
                }
            }
        });
        return map;
    }

    private void computeLabels(LabelHandler handler) {
        Iterator<Map.Entry<Integer, PDPageLabelRange>> iterator = this.labels.entrySet().iterator();
        if (!iterator.hasNext()) {
            return;
        }
        int pageIndex = 0;
        Map.Entry<Integer, PDPageLabelRange> lastEntry = iterator.next();
        while (iterator.hasNext()) {
            Map.Entry<Integer, PDPageLabelRange> entry = iterator.next();
            int numPages = entry.getKey() - lastEntry.getKey();
            LabelGenerator gen = new LabelGenerator(lastEntry.getValue(), numPages);
            while (gen.hasNext()) {
                handler.newLabel(pageIndex, gen.next());
                ++pageIndex;
            }
            lastEntry = entry;
        }
        LabelGenerator gen = new LabelGenerator(lastEntry.getValue(), this.doc.getNumberOfPages() - lastEntry.getKey());
        while (gen.hasNext()) {
            handler.newLabel(pageIndex, gen.next());
            ++pageIndex;
        }
    }

    private static class LabelGenerator
    implements Iterator<String> {
        private final PDPageLabelRange labelInfo;
        private final int numPages;
        private int currentPage;
        private static final String[][] ROMANS = new String[][]{{"", "i", "ii", "iii", "iv", "v", "vi", "vii", "viii", "ix"}, {"", "x", "xx", "xxx", "xl", "l", "lx", "lxx", "lxxx", "xc"}, {"", "c", "cc", "ccc", "cd", "d", "dc", "dcc", "dccc", "cm"}};

        LabelGenerator(PDPageLabelRange label, int pages) {
            this.labelInfo = label;
            this.numPages = pages;
            this.currentPage = 0;
        }

        @Override
        public boolean hasNext() {
            return this.currentPage < this.numPages;
        }

        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            StringBuilder buf = new StringBuilder();
            if (this.labelInfo.getPrefix() != null) {
                String label = this.labelInfo.getPrefix();
                while (label.lastIndexOf(0) != -1) {
                    label = label.substring(0, label.length() - 1);
                }
                buf.append(label);
            }
            if (this.labelInfo.getStyle() != null) {
                buf.append(this.getNumber(this.labelInfo.getStart() + this.currentPage, this.labelInfo.getStyle()));
            }
            ++this.currentPage;
            return buf.toString();
        }

        private String getNumber(int pageIndex, String style) {
            if ("D".equals(style)) {
                return Integer.toString(pageIndex);
            }
            if ("a".equals(style)) {
                return LabelGenerator.makeLetterLabel(pageIndex);
            }
            if ("A".equals(style)) {
                return LabelGenerator.makeLetterLabel(pageIndex).toUpperCase();
            }
            if ("r".equals(style)) {
                return LabelGenerator.makeRomanLabel(pageIndex);
            }
            if ("R".equals(style)) {
                return LabelGenerator.makeRomanLabel(pageIndex).toUpperCase();
            }
            return Integer.toString(pageIndex);
        }

        private static String makeRomanLabel(int pageIndex) {
            StringBuilder buf = new StringBuilder();
            for (int power = 0; power < 3 && pageIndex > 0; pageIndex /= 10, ++power) {
                buf.insert(0, ROMANS[power][pageIndex % 10]);
            }
            for (int i = 0; i < pageIndex; ++i) {
                buf.insert(0, 'm');
            }
            return buf.toString();
        }

        private static String makeLetterLabel(int num) {
            StringBuilder buf = new StringBuilder();
            int numLetters = num / 26 + Integer.signum(num % 26);
            int letter = num % 26 + 26 * (1 - Integer.signum(num % 26)) + 64;
            for (int i = 0; i < numLetters; ++i) {
                buf.appendCodePoint(letter);
            }
            return buf.toString();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static interface LabelHandler {
        public void newLabel(int var1, String var2);
    }
}

