/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel.common;

import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.PDDocument;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;

public class PDObjectStream
extends PDStream {
    public PDObjectStream(COSStream str) {
        super(str);
    }

    public static PDObjectStream createStream(PDDocument document) {
        COSStream cosStream = document.getDocument().createCOSStream();
        PDObjectStream strm = new PDObjectStream(cosStream);
        strm.getStream().setItem(COSName.TYPE, (COSBase)COSName.OBJ_STM);
        return strm;
    }

    public String getType() {
        return this.getStream().getNameAsString(COSName.TYPE);
    }

    public int getNumberOfObjects() {
        return this.getStream().getInt(COSName.N, 0);
    }

    public void setNumberOfObjects(int n) {
        this.getStream().setInt(COSName.N, n);
    }

    public int getFirstByteOffset() {
        return this.getStream().getInt(COSName.FIRST, 0);
    }

    public void setFirstByteOffset(int n) {
        this.getStream().setInt(COSName.FIRST, n);
    }

    public PDObjectStream getExtends() {
        PDObjectStream retval = null;
        COSStream stream = (COSStream)this.getStream().getDictionaryObject(COSName.EXTENDS);
        if (stream != null) {
            retval = new PDObjectStream(stream);
        }
        return retval;
    }

    public void setExtends(PDObjectStream stream) {
        this.getStream().setItem(COSName.EXTENDS, (COSObjectable)stream);
    }
}

