/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdmodel;

import android.util.Log;
import com.tom_roush.pdfbox.contentstream.PDContentStream;
import com.tom_roush.pdfbox.cos.COSArray;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSFloat;
import com.tom_roush.pdfbox.cos.COSName;
import com.tom_roush.pdfbox.cos.COSNumber;
import com.tom_roush.pdfbox.cos.COSStream;
import com.tom_roush.pdfbox.pdmodel.PDPageTree;
import com.tom_roush.pdfbox.pdmodel.PDResources;
import com.tom_roush.pdfbox.pdmodel.ResourceCache;
import com.tom_roush.pdfbox.pdmodel.common.COSArrayList;
import com.tom_roush.pdfbox.pdmodel.common.COSObjectable;
import com.tom_roush.pdfbox.pdmodel.common.PDMetadata;
import com.tom_roush.pdfbox.pdmodel.common.PDRectangle;
import com.tom_roush.pdfbox.pdmodel.common.PDStream;
import com.tom_roush.pdfbox.pdmodel.interactive.action.PDPageAdditionalActions;
import com.tom_roush.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import com.tom_roush.pdfbox.pdmodel.interactive.pagenavigation.PDThreadBead;
import com.tom_roush.pdfbox.pdmodel.interactive.pagenavigation.PDTransition;
import com.tom_roush.pdfbox.util.Matrix;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PDPage
implements COSObjectable,
PDContentStream {
    private final COSDictionary page;
    private PDResources pageResources;
    private ResourceCache resourceCache;
    private PDRectangle mediaBox;

    public PDPage() {
        this(PDRectangle.LETTER);
    }

    public PDPage(PDRectangle mediaBox) {
        this.page = new COSDictionary();
        this.page.setItem(COSName.TYPE, (COSBase)COSName.PAGE);
        this.page.setItem(COSName.MEDIA_BOX, (COSObjectable)mediaBox);
    }

    public PDPage(COSDictionary pageDictionary) {
        this.page = pageDictionary;
    }

    PDPage(COSDictionary pageDictionary, ResourceCache resourceCache) {
        this.page = pageDictionary;
        this.resourceCache = resourceCache;
    }

    @Override
    public COSDictionary getCOSObject() {
        return this.page;
    }

    public Iterator<PDStream> getContentStreams() {
        ArrayList<PDStream> streams = new ArrayList<PDStream>();
        COSBase base = this.page.getDictionaryObject(COSName.CONTENTS);
        if (base instanceof COSStream) {
            streams.add(new PDStream((COSStream)base));
        } else if (base instanceof COSArray && ((COSArray)base).size() > 0) {
            COSArray array = (COSArray)base;
            for (int i = 0; i < streams.size(); ++i) {
                COSStream stream = (COSStream)array.getObject(i);
                streams.add(new PDStream(stream));
            }
        }
        return streams.iterator();
    }

    @Override
    public InputStream getContents() throws IOException {
        COSBase base = this.page.getDictionaryObject(COSName.CONTENTS);
        if (base instanceof COSStream) {
            return ((COSStream)base).createInputStream();
        }
        if (base instanceof COSArray && ((COSArray)base).size() > 0) {
            COSArray streams = (COSArray)base;
            byte[] delimiter = new byte[]{10};
            ArrayList<InputStream> inputStreams = new ArrayList<InputStream>();
            for (int i = 0; i < streams.size(); ++i) {
                COSStream stream = (COSStream)streams.getObject(i);
                inputStreams.add(stream.createInputStream());
                inputStreams.add(new ByteArrayInputStream(delimiter));
            }
            return new SequenceInputStream(Collections.enumeration(inputStreams));
        }
        return null;
    }

    public boolean hasContents() {
        COSBase contents = this.page.getDictionaryObject(COSName.CONTENTS);
        if (contents instanceof COSStream) {
            return ((COSStream)contents).size() > 0;
        }
        if (contents instanceof COSArray) {
            return ((COSArray)contents).size() > 0;
        }
        return false;
    }

    @Override
    public PDResources getResources() {
        COSDictionary resources;
        if (this.pageResources == null && (resources = (COSDictionary)PDPageTree.getInheritableAttribute(this.page, COSName.RESOURCES)) != null) {
            this.pageResources = new PDResources(resources, this.resourceCache);
        }
        return this.pageResources;
    }

    public void setResources(PDResources resources) {
        this.pageResources = resources;
        if (resources != null) {
            this.page.setItem(COSName.RESOURCES, (COSObjectable)resources);
        } else {
            this.page.removeItem(COSName.RESOURCES);
        }
    }

    public int getStructParents() {
        return this.page.getInt(COSName.STRUCT_PARENTS, 0);
    }

    @Override
    public PDRectangle getBBox() {
        return this.getCropBox();
    }

    public void setStructParents(int structParents) {
        this.page.setInt(COSName.STRUCT_PARENTS, structParents);
    }

    public PDRectangle getMediaBox() {
        COSArray array;
        if (this.mediaBox == null && (array = (COSArray)PDPageTree.getInheritableAttribute(this.page, COSName.MEDIA_BOX)) != null) {
            this.mediaBox = new PDRectangle(array);
        }
        if (this.mediaBox == null) {
            Log.d((String)"PdfBox-Android", (String)"Can't find MediaBox, will use U.S. Letter");
            this.mediaBox = PDRectangle.LETTER;
        }
        return this.mediaBox;
    }

    public void setMediaBox(PDRectangle mediaBox) {
        this.mediaBox = mediaBox;
        if (mediaBox == null) {
            this.page.removeItem(COSName.MEDIA_BOX);
        } else {
            this.page.setItem(COSName.MEDIA_BOX, (COSBase)mediaBox.getCOSArray());
        }
    }

    public PDRectangle getCropBox() {
        COSArray array = (COSArray)PDPageTree.getInheritableAttribute(this.page, COSName.CROP_BOX);
        if (array != null) {
            return this.clipToMediaBox(new PDRectangle(array));
        }
        return this.getMediaBox();
    }

    @Override
    public Matrix getMatrix() {
        return new Matrix();
    }

    public void setCropBox(PDRectangle cropBox) {
        if (cropBox == null) {
            this.page.removeItem(COSName.CROP_BOX);
        } else {
            this.page.setItem(COSName.CROP_BOX, (COSBase)cropBox.getCOSArray());
        }
    }

    public PDRectangle getBleedBox() {
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.BLEED_BOX);
        PDRectangle retval = array != null ? new PDRectangle(array) : this.clipToMediaBox(new PDRectangle(array));
        return retval;
    }

    public void setBleedBox(PDRectangle bleedBox) {
        if (bleedBox == null) {
            this.page.removeItem(COSName.BLEED_BOX);
        } else {
            this.page.setItem(COSName.BLEED_BOX, (COSObjectable)bleedBox);
        }
    }

    public PDRectangle getTrimBox() {
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.TRIM_BOX);
        PDRectangle retval = array != null ? this.clipToMediaBox(new PDRectangle(array)) : this.getCropBox();
        return retval;
    }

    public void setTrimBox(PDRectangle trimBox) {
        if (trimBox == null) {
            this.page.removeItem(COSName.TRIM_BOX);
        } else {
            this.page.setItem(COSName.TRIM_BOX, (COSObjectable)trimBox);
        }
    }

    public PDRectangle getArtBox() {
        COSArray array = (COSArray)this.page.getDictionaryObject(COSName.ART_BOX);
        PDRectangle retval = array != null ? this.clipToMediaBox(new PDRectangle(array)) : this.getCropBox();
        return retval;
    }

    public void setArtBox(PDRectangle artBox) {
        if (artBox == null) {
            this.page.removeItem(COSName.ART_BOX);
        } else {
            this.page.setItem(COSName.ART_BOX, (COSObjectable)artBox);
        }
    }

    private PDRectangle clipToMediaBox(PDRectangle box) {
        PDRectangle mediaBox = this.getMediaBox();
        PDRectangle result = new PDRectangle();
        result.setLowerLeftX(Math.max(mediaBox.getLowerLeftX(), box.getLowerLeftX()));
        result.setLowerLeftY(Math.max(mediaBox.getLowerLeftY(), box.getLowerLeftY()));
        result.setUpperRightX(Math.min(mediaBox.getUpperRightX(), box.getUpperRightX()));
        result.setUpperRightY(Math.min(mediaBox.getUpperRightY(), box.getUpperRightY()));
        return result;
    }

    public int getRotation() {
        int rotationAngle;
        COSBase obj = PDPageTree.getInheritableAttribute(this.page, COSName.ROTATE);
        if (obj instanceof COSNumber && (rotationAngle = ((COSNumber)obj).intValue()) % 90 == 0) {
            return (rotationAngle % 360 + 360) % 360;
        }
        return 0;
    }

    public void setRotation(int rotation) {
        this.page.setInt(COSName.ROTATE, rotation);
    }

    public void setContents(PDStream contents) {
        this.page.setItem(COSName.CONTENTS, (COSObjectable)contents);
    }

    public void setContents(List<PDStream> contents) {
        COSArray array = new COSArray();
        for (PDStream stream : contents) {
            array.add(stream);
        }
        this.page.setItem(COSName.CONTENTS, (COSBase)array);
    }

    public List<PDThreadBead> getThreadBeads() {
        COSArray beads = (COSArray)this.page.getDictionaryObject(COSName.B);
        if (beads == null) {
            beads = new COSArray();
        }
        ArrayList<PDThreadBead> pdObjects = new ArrayList<PDThreadBead>();
        for (int i = 0; i < beads.size(); ++i) {
            COSDictionary beadDic = (COSDictionary)beads.getObject(i);
            PDThreadBead bead = null;
            if (beadDic != null) {
                bead = new PDThreadBead(beadDic);
            }
            pdObjects.add(bead);
        }
        return new COSArrayList<PDThreadBead>(pdObjects, beads);
    }

    public void setThreadBeads(List<PDThreadBead> beads) {
        this.page.setItem(COSName.B, (COSBase)COSArrayList.converterToCOSArray(beads));
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSStream stream = (COSStream)this.page.getDictionaryObject(COSName.METADATA);
        if (stream != null) {
            retval = new PDMetadata(stream);
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.page.setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public PDPageAdditionalActions getActions() {
        COSDictionary addAct = (COSDictionary)this.page.getDictionaryObject(COSName.AA);
        if (addAct == null) {
            addAct = new COSDictionary();
            this.page.setItem(COSName.AA, (COSBase)addAct);
        }
        return new PDPageAdditionalActions(addAct);
    }

    public void setActions(PDPageAdditionalActions actions) {
        this.page.setItem(COSName.AA, (COSObjectable)actions);
    }

    public PDTransition getTransition() {
        COSDictionary transitionDictionary = (COSDictionary)this.page.getDictionaryObject(COSName.TRANS);
        return transitionDictionary == null ? null : new PDTransition(transitionDictionary);
    }

    public void setTransition(PDTransition transition) {
        this.page.setItem(COSName.TRANS, (COSObjectable)transition);
    }

    public void setTransition(PDTransition transition, float duration) {
        this.page.setItem(COSName.TRANS, (COSObjectable)transition);
        this.page.setItem(COSName.DUR, (COSBase)new COSFloat(duration));
    }

    public List<PDAnnotation> getAnnotations() throws IOException {
        COSArrayList<PDAnnotation> retval;
        COSArray annots = (COSArray)this.page.getDictionaryObject(COSName.ANNOTS);
        if (annots == null) {
            annots = new COSArray();
            this.page.setItem(COSName.ANNOTS, (COSBase)annots);
            retval = new COSArrayList(new ArrayList(), annots);
        } else {
            ArrayList<PDAnnotation> actuals = new ArrayList<PDAnnotation>();
            for (int i = 0; i < annots.size(); ++i) {
                COSBase item = annots.getObject(i);
                if (item == null) continue;
                actuals.add(PDAnnotation.createAnnotation(item));
            }
            retval = new COSArrayList<PDAnnotation>(actuals, annots);
        }
        return retval;
    }

    public void setAnnotations(List<PDAnnotation> annotations) {
        this.page.setItem(COSName.ANNOTS, (COSBase)COSArrayList.converterToCOSArray(annotations));
    }

    public boolean equals(Object other) {
        return other instanceof PDPage && ((PDPage)other).getCOSObject() == this.getCOSObject();
    }

    public int hashCode() {
        return this.page.hashCode();
    }

    public ResourceCache getResourceCache() {
        return this.resourceCache;
    }
}

