/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.pdfparser;

import android.util.Log;
import com.tom_roush.pdfbox.cos.COSBase;
import com.tom_roush.pdfbox.cos.COSDictionary;
import com.tom_roush.pdfbox.cos.COSDocument;
import com.tom_roush.pdfbox.io.IOUtils;
import com.tom_roush.pdfbox.io.RandomAccessBuffer;
import com.tom_roush.pdfbox.io.RandomAccessFile;
import com.tom_roush.pdfbox.pdfparser.COSParser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class FDFParser
extends COSParser {
    public FDFParser(String filename) throws IOException {
        this(new File(filename));
    }

    public FDFParser(File file) throws IOException {
        super(new RandomAccessFile(file, "r"));
        this.fileLen = file.length();
        this.init();
    }

    public FDFParser(InputStream input) throws IOException {
        super(new RandomAccessBuffer(input));
        this.fileLen = this.source.length();
        this.init();
    }

    private void init() throws IOException {
        String eofLookupRangeStr = System.getProperty("com.tom_roush.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange");
        if (eofLookupRangeStr != null) {
            try {
                this.setEOFLookupRange(Integer.parseInt(eofLookupRangeStr));
            }
            catch (NumberFormatException nfe) {
                Log.w((String)"PdfBox-Android", (String)("System property com.tom_roush.pdfbox.pdfparser.nonSequentialPDFParser.eofLookupRange does not contain an integer value, but: '" + eofLookupRangeStr + "'"));
            }
        }
        this.document = new COSDocument(false);
    }

    private void initialParse() throws IOException {
        COSDictionary trailer = null;
        long startXRefOffset = this.getStartxrefOffset();
        trailer = startXRefOffset > 0L ? this.parseXref(startXRefOffset) : this.rebuildTrailer();
        COSBase rootObject = this.parseTrailerValuesDynamically(trailer);
        if (rootObject instanceof COSDictionary) {
            this.parseDictObjects((COSDictionary)rootObject, null);
        }
        this.initialParseDone = true;
    }

    public void parse() throws IOException {
        boolean exceptionOccurred = true;
        try {
            if (!this.parseFDFHeader()) {
                throw new IOException("Error: Header doesn't contain versioninfo");
            }
            this.initialParse();
            exceptionOccurred = false;
        }
        finally {
            if (exceptionOccurred && this.document != null) {
                IOUtils.closeQuietly(this.document);
                this.document = null;
            }
        }
    }
}

