/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.pdfbox.filter;

import com.tom_roush.pdfbox.io.IOUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Predictor {
    private Predictor() {
    }

    static void decodePredictor(int predictor, int colors, int bitsPerComponent, int columns, InputStream in, OutputStream out) throws IOException {
        if (predictor == 1) {
            IOUtils.copy(in, out);
        } else {
            int bitsPerPixel = colors * bitsPerComponent;
            int bytesPerPixel = (bitsPerPixel + 7) / 8;
            int rowlength = (columns * bitsPerPixel + 7) / 8;
            byte[] actline = new byte[rowlength];
            byte[] lastline = new byte[rowlength];
            int linepredictor = predictor;
            while (in.available() > 0) {
                int i;
                if (predictor >= 10) {
                    linepredictor = in.read();
                    if (linepredictor == -1) {
                        return;
                    }
                    linepredictor += 10;
                }
                for (int offset = 0; offset < rowlength && (i = in.read(actline, offset, rowlength - offset)) != -1; offset += i) {
                }
                switch (linepredictor) {
                    case 2: {
                        int left;
                        int sub;
                        int p;
                        if (bitsPerComponent == 16) {
                            for (p = 0; p < rowlength; p += 2) {
                                sub = ((actline[p] & 0xFF) << 8) + (actline[p + 1] & 0xFF);
                                left = p - bytesPerPixel >= 0 ? ((actline[p - bytesPerPixel] & 0xFF) << 8) + (actline[p - bytesPerPixel + 1] & 0xFF) : 0;
                                actline[p] = (byte)(sub + left >> 8 & 0xFF);
                                actline[p + 1] = (byte)(sub + left & 0xFF);
                            }
                        } else {
                            if (bitsPerComponent < 8) {
                                throw new IOException("TIFF-Predictor with " + bitsPerComponent + " bits per component not supported; please open JIRA issue with sample PDF");
                            }
                            for (p = 0; p < rowlength; ++p) {
                                sub = actline[p] & 0xFF;
                                left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                                actline[p] = (byte)(sub + left);
                            }
                        }
                        break;
                    }
                    case 10: {
                        break;
                    }
                    case 11: {
                        int left;
                        int sub;
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            sub = actline[p];
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] : 0;
                            actline[p] = (byte)(sub + left);
                        }
                        break;
                    }
                    case 12: {
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int up = actline[p] & 0xFF;
                            int prior = lastline[p] & 0xFF;
                            actline[p] = (byte)(up + prior & 0xFF);
                        }
                        break;
                    }
                    case 13: {
                        int left;
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int avg = actline[p] & 0xFF;
                            left = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            int up = lastline[p] & 0xFF;
                            actline[p] = (byte)(avg + (left + up) / 2 & 0xFF);
                        }
                        break;
                    }
                    case 14: {
                        int p;
                        for (p = 0; p < rowlength; ++p) {
                            int paeth = actline[p] & 0xFF;
                            int a = p - bytesPerPixel >= 0 ? actline[p - bytesPerPixel] & 0xFF : 0;
                            int b = lastline[p] & 0xFF;
                            int c = p - bytesPerPixel >= 0 ? lastline[p - bytesPerPixel] & 0xFF : 0;
                            int value = a + b - c;
                            int absa = Math.abs(value - a);
                            int absb = Math.abs(value - b);
                            int absc = Math.abs(value - c);
                            actline[p] = absa <= absb && absa <= absc ? (byte)(paeth + a & 0xFF) : (absb <= absc ? (byte)(paeth + b & 0xFF) : (byte)(paeth + c & 0xFF));
                        }
                        break;
                    }
                }
                System.arraycopy(actline, 0, lastline, 0, rowlength);
                out.write(actline);
            }
        }
    }
}

