/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.ttf;

import com.tom_roush.fontbox.ttf.TTFDataStream;
import com.tom_roush.fontbox.ttf.TTFTable;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import com.tom_roush.fontbox.ttf.VerticalHeaderTable;
import java.io.IOException;

public class VerticalMetricsTable
extends TTFTable {
    public static final String TAG = "vmtx";
    private int[] advanceHeight;
    private short[] topSideBearing;
    private short[] nonVerticalTopSideBearing;
    private int numVMetrics;

    VerticalMetricsTable(TrueTypeFont font) {
        super(font);
    }

    @Override
    public void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        VerticalHeaderTable vHeader = ttf.getVerticalHeader();
        this.numVMetrics = vHeader.getNumberOfVMetrics();
        int numGlyphs = ttf.getNumberOfGlyphs();
        int bytesRead = 0;
        this.advanceHeight = new int[this.numVMetrics];
        this.topSideBearing = new short[this.numVMetrics];
        for (int i = 0; i < this.numVMetrics; ++i) {
            this.advanceHeight[i] = data.readUnsignedShort();
            this.topSideBearing[i] = data.readSignedShort();
            bytesRead += 4;
        }
        if ((long)bytesRead < this.getLength()) {
            int numberNonVertical = numGlyphs - this.numVMetrics;
            if (numberNonVertical < 0) {
                numberNonVertical = numGlyphs;
            }
            this.nonVerticalTopSideBearing = new short[numberNonVertical];
            for (int i = 0; i < numberNonVertical; ++i) {
                if ((long)bytesRead >= this.getLength()) continue;
                this.nonVerticalTopSideBearing[i] = data.readSignedShort();
                bytesRead += 2;
            }
        }
        this.initialized = true;
    }

    public int getAdvanceHeight(int gid) {
        if (gid < this.numVMetrics) {
            return this.advanceHeight[gid];
        }
        return this.advanceHeight[this.advanceHeight.length - 1];
    }
}

