/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.ttf;

import com.tom_roush.fontbox.ttf.NameRecord;
import com.tom_roush.fontbox.ttf.TTFDataStream;
import com.tom_roush.fontbox.ttf.TTFTable;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NamingTable
extends TTFTable {
    public static final String TAG = "name";
    private final List<NameRecord> nameRecords = new ArrayList<NameRecord>();
    private final Map<Integer, Map<Integer, Map<Integer, Map<Integer, String>>>> lookupTable = new HashMap<Integer, Map<Integer, Map<Integer, Map<Integer, String>>>>();
    private String fontFamily = null;
    private String fontSubFamily = null;
    private String psName = null;

    NamingTable(TrueTypeFont font) {
        super(font);
    }

    @Override
    public void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        NameRecord nr2;
        int i;
        int formatSelector = data.readUnsignedShort();
        int numberOfNameRecords = data.readUnsignedShort();
        int offsetToStartOfStringStorage = data.readUnsignedShort();
        for (i = 0; i < numberOfNameRecords; ++i) {
            nr2 = new NameRecord();
            nr2.initData(ttf, data);
            this.nameRecords.add(nr2);
        }
        for (i = 0; i < numberOfNameRecords; ++i) {
            nr2 = this.nameRecords.get(i);
            if ((long)nr2.getStringOffset() > this.getLength()) {
                nr2.setString(null);
                continue;
            }
            data.seek(this.getOffset() + 6L + (long)(numberOfNameRecords * 2 * 6) + (long)nr2.getStringOffset());
            int platform = nr2.getPlatformId();
            int encoding = nr2.getPlatformEncodingId();
            String charset = "ISO-8859-1";
            if (platform == 3 && (encoding == 1 || encoding == 0)) {
                charset = "UTF-16";
            } else if (platform == 2) {
                if (encoding == 0) {
                    charset = "US-ASCII";
                } else if (encoding == 1) {
                    charset = "ISO-10646-1";
                } else if (encoding == 2) {
                    charset = "ISO-8859-1";
                }
            }
            String string = data.readString(nr2.getStringLength(), charset);
            nr2.setString(string);
        }
        for (NameRecord nr2 : this.nameRecords) {
            Map<Integer, Map<Integer, String>> encodingLookup;
            Map<Integer, Map<Integer, Map<Integer, String>>> platformLookup;
            if (!this.lookupTable.containsKey(nr2.getNameId())) {
                this.lookupTable.put(nr2.getNameId(), new HashMap());
            }
            if (!(platformLookup = this.lookupTable.get(nr2.getNameId())).containsKey(nr2.getPlatformId())) {
                platformLookup.put(nr2.getPlatformId(), new HashMap());
            }
            if (!(encodingLookup = platformLookup.get(nr2.getPlatformId())).containsKey(nr2.getPlatformEncodingId())) {
                encodingLookup.put(nr2.getPlatformEncodingId(), new HashMap());
            }
            Map<Integer, String> languageLookup = encodingLookup.get(nr2.getPlatformEncodingId());
            languageLookup.put(nr2.getLanguageId(), nr2.getString());
        }
        this.fontFamily = this.getEnglishName(1);
        this.fontSubFamily = this.getEnglishName(2);
        this.psName = this.getName(6, 1, 0, 0);
        if (this.psName == null) {
            this.psName = this.getName(6, 3, 1, 1033);
        }
        this.initialized = true;
    }

    private String getEnglishName(int nameId) {
        for (int i = 4; i <= 0; --i) {
            String nameUni = this.getName(nameId, 0, i, 0);
            if (nameUni == null) continue;
            return nameUni;
        }
        String nameWin = this.getName(nameId, 3, 1, 1033);
        if (nameWin != null) {
            return nameWin;
        }
        String nameMac = this.getName(nameId, 1, 0, 0);
        if (nameMac != null) {
            return nameMac;
        }
        return null;
    }

    public String getName(int nameId, int platformId, int encodingId, int languageId) {
        Map<Integer, Map<Integer, Map<Integer, String>>> platforms = this.lookupTable.get(nameId);
        if (platforms == null) {
            return null;
        }
        Map<Integer, Map<Integer, String>> encodings = platforms.get(platformId);
        if (encodings == null) {
            return null;
        }
        Map<Integer, String> languages = encodings.get(encodingId);
        if (languages == null) {
            return null;
        }
        return languages.get(languageId);
    }

    public List<NameRecord> getNameRecords() {
        return this.nameRecords;
    }

    public String getFontFamily() {
        return this.fontFamily;
    }

    public String getFontSubFamily() {
        return this.fontSubFamily;
    }

    public String getPostScriptName() {
        return this.psName;
    }
}

