/*
 * Decompiled with CFR 0.152.
 */
package com.tom_roush.fontbox.ttf;

import android.util.Log;
import com.tom_roush.fontbox.ttf.KerningSubtable;
import com.tom_roush.fontbox.ttf.TTFDataStream;
import com.tom_roush.fontbox.ttf.TTFTable;
import com.tom_roush.fontbox.ttf.TrueTypeFont;
import java.io.IOException;

public class KerningTable
extends TTFTable {
    public static final String TAG = "kern";
    private KerningSubtable[] subtables;

    KerningTable(TrueTypeFont font) {
        super(font);
    }

    @Override
    public void read(TrueTypeFont ttf, TTFDataStream data) throws IOException {
        int version = data.readUnsignedShort();
        if (version != 0) {
            version = version << 16 | data.readUnsignedShort();
        }
        int numSubtables = 0;
        if (version == 0) {
            numSubtables = data.readUnsignedShort();
        } else if (version == 1) {
            numSubtables = (int)data.readUnsignedInt();
        } else {
            Log.d((String)"PdfBox-Android", (String)("Skipped kerning table due to an unsupported kerning table version: " + version));
        }
        if (numSubtables > 0) {
            this.subtables = new KerningSubtable[numSubtables];
            for (int i = 0; i < numSubtables; ++i) {
                KerningSubtable subtable = new KerningSubtable();
                subtable.read(data, version);
                this.subtables[i] = subtable;
            }
        }
        this.initialized = true;
    }

    public KerningSubtable getHorizontalKerningSubtable() {
        return this.getHorizontalKerningSubtable(false);
    }

    public KerningSubtable getHorizontalKerningSubtable(boolean cross) {
        if (this.subtables != null) {
            for (KerningSubtable s : this.subtables) {
                if (!s.isHorizontalKerning(cross)) continue;
                return s;
            }
        }
        return null;
    }
}

