/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiTypeForClass;
import com.toedter.spring.hateoas.jsonapi.ReflectionUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.atteo.evo.inflector.English;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
final class JsonApiResourceIdentifier {
    public static final String CANNOT_COMPUTE_JSON_API_RESOURCE_ID = "Cannot compute JSON:API resource id.";
    public static final String JSONAPI_ID_ANNOTATION = "com.toedter.spring.hateoas.jsonapi.JsonApiId";
    public static final String JSONAPI_TYPE_ANNOTATION = "com.toedter.spring.hateoas.jsonapi.JsonApiType";
    public static final String JPA_ID_ANNOTATION = "jakarta.persistence.Id";
    public static final String ID_LITERAL = "id";
    public static final String TYPE_LITERAL = "type";
    private final String id;
    private final String type;
    private final Map<String, Object> meta;

    @JsonCreator
    public JsonApiResourceIdentifier(@JsonProperty String id, @JsonProperty String type, @Nullable Map<String, Object> meta) {
        this.id = id;
        this.type = type;
        this.meta = meta;
    }

    @JsonCreator
    public JsonApiResourceIdentifier(@JsonProperty String id, @JsonProperty String type) {
        this(id, type, null);
    }

    static ResourceField getId(Object object, JsonApiConfiguration jsonApiConfiguration) {
        return JsonApiResourceIdentifier.getResourceField(JsonApiResourceField.ID, object, jsonApiConfiguration);
    }

    static ResourceField getType(Object object, JsonApiConfiguration jsonApiConfiguration) {
        return JsonApiResourceIdentifier.getResourceField(JsonApiResourceField.TYPE, object, jsonApiConfiguration);
    }

    private static ResourceField getResourceField(JsonApiResourceField resourceField, Object object, JsonApiConfiguration jsonApiConfiguration) {
        try {
            if (resourceField == JsonApiResourceField.TYPE && object.getClass().isAnnotationPresent(JsonApiTypeForClass.class)) {
                JsonApiTypeForClass annotation = object.getClass().getAnnotation(JsonApiTypeForClass.class);
                return new ResourceField(TYPE_LITERAL, annotation.value());
            }
            Field[] declaredFields = ReflectionUtils.getAllDeclaredFields(object.getClass());
            Field jpaIdField = null;
            for (Field field : declaredFields) {
                Annotation[] annotations;
                field.setAccessible(true);
                for (Annotation annotation : annotations = field.getAnnotations()) {
                    String annotationName = annotation.annotationType().getCanonicalName();
                    if (resourceField == JsonApiResourceField.ID) {
                        if (JPA_ID_ANNOTATION.equals(annotationName)) {
                            jpaIdField = field;
                        }
                        if (!JSONAPI_ID_ANNOTATION.equals(annotationName)) continue;
                        return new ResourceField(field.getName(), field.get(object).toString());
                    }
                    if (!JSONAPI_TYPE_ANNOTATION.equals(annotationName)) continue;
                    return new ResourceField(field.getName(), field.get(object).toString());
                }
            }
            Method[] declaredMethods = org.springframework.util.ReflectionUtils.getAllDeclaredMethods(object.getClass());
            Method jpaIdMethod = null;
            for (Method method : declaredMethods) {
                Annotation[] annotations;
                for (Annotation annotation : annotations = method.getAnnotations()) {
                    String annotationName = annotation.annotationType().getCanonicalName();
                    if (resourceField == JsonApiResourceField.ID) {
                        if (JPA_ID_ANNOTATION.equals(annotationName)) {
                            jpaIdMethod = method;
                        }
                        if (!JSONAPI_ID_ANNOTATION.equals(annotationName) || method.getReturnType() == Void.TYPE) continue;
                        return JsonApiResourceIdentifier.getResourceFieldForMethod(object, method, resourceField);
                    }
                    if (!JSONAPI_TYPE_ANNOTATION.equals(annotationName) || method.getReturnType() == Void.TYPE) continue;
                    return JsonApiResourceIdentifier.getResourceFieldForMethod(object, method, resourceField);
                }
            }
            if (jpaIdField != null) {
                return new ResourceField(jpaIdField.getName(), jpaIdField.get(object).toString());
            }
            if (jpaIdMethod != null) {
                return JsonApiResourceIdentifier.getResourceFieldForMethod(object, jpaIdMethod, resourceField);
            }
            if (resourceField == JsonApiResourceField.ID) {
                Field field = org.springframework.util.ReflectionUtils.findField(object.getClass(), (String)ID_LITERAL);
                field.setAccessible(true);
                Object id = field.get(object);
                if (id == null) {
                    throw new IllegalStateException(CANNOT_COMPUTE_JSON_API_RESOURCE_ID);
                }
                return new ResourceField(ID_LITERAL, id.toString());
            }
            String type = jsonApiConfiguration.getTypeForClass(object.getClass());
            if (type != null) {
                return new ResourceField(TYPE_LITERAL, type);
            }
            String jsonApiType = object.getClass().getSimpleName();
            if (jsonApiConfiguration.isLowerCasedTypeRendered()) {
                jsonApiType = jsonApiType.toLowerCase();
            }
            if (jsonApiConfiguration.isPluralizedTypeRendered()) {
                jsonApiType = English.plural((String)jsonApiType, (int)2);
            }
            return new ResourceField(TYPE_LITERAL, jsonApiType);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot compute JSON:API resource id.::: " + object);
        }
    }

    private static ResourceField getResourceFieldForMethod(Object object, Method jsonApiIdMethod, JsonApiResourceField resourceField) throws IllegalAccessException, InvocationTargetException {
        String methodName = jsonApiIdMethod.getName();
        if (methodName.startsWith("get")) {
            String fieldName = StringUtils.uncapitalize((String)methodName.substring(3));
            return new ResourceField(fieldName, jsonApiIdMethod.invoke(object, new Object[0]).toString());
        }
        return new ResourceField(resourceField.name(), jsonApiIdMethod.invoke(object, new Object[0]).toString());
    }

    static void setJsonApiResourceFieldAttributeForObject(Object object, JsonApiResourceField name, String value) {
        block12: {
            Field[] declaredFields = ReflectionUtils.getAllDeclaredFields(object.getClass());
            try {
                Method[] declaredMethods;
                for (Field field : declaredFields) {
                    Annotation[] annotations;
                    field.setAccessible(true);
                    for (Annotation annotation : annotations = field.getAnnotations()) {
                        String annotationName = annotation.annotationType().getCanonicalName();
                        if ((name != JsonApiResourceField.ID || !JPA_ID_ANNOTATION.equals(annotationName) && !JSONAPI_ID_ANNOTATION.equals(annotationName)) && (name != JsonApiResourceField.TYPE || !JSONAPI_TYPE_ANNOTATION.equals(annotationName))) continue;
                        JsonApiResourceIdentifier.setFieldValue(object, value, field);
                        return;
                    }
                }
                for (Method method : declaredMethods = org.springframework.util.ReflectionUtils.getAllDeclaredMethods(object.getClass())) {
                    Annotation[] annotations;
                    for (Annotation annotation : annotations = method.getAnnotations()) {
                        String annotationName = annotation.annotationType().getCanonicalName();
                        boolean isAnnotatedMethod = false;
                        if (name == JsonApiResourceField.ID && (JPA_ID_ANNOTATION.equals(annotationName) || JSONAPI_ID_ANNOTATION.equals(annotationName))) {
                            isAnnotatedMethod = true;
                        } else if (name == JsonApiResourceField.TYPE && JSONAPI_TYPE_ANNOTATION.equals(annotationName)) {
                            isAnnotatedMethod = true;
                        }
                        if (!isAnnotatedMethod || method.getParameterCount() != 1) continue;
                        if (method.getParameterTypes()[0] == UUID.class) {
                            method.invoke(object, UUID.fromString(value));
                        } else {
                            method.invoke(object, value);
                        }
                        return;
                    }
                }
                if (name != JsonApiResourceField.ID) break block12;
                Field field = org.springframework.util.ReflectionUtils.findField(object.getClass(), (String)name.name().toLowerCase());
                if (field != null) {
                    field.setAccessible(true);
                    JsonApiResourceIdentifier.setFieldValue(object, value, field);
                    break block12;
                }
                throw new RuntimeException();
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot set JSON:API field '" + name + "' on object of type " + object.getClass().getSimpleName());
            }
        }
    }

    private static void setFieldValue(Object object, @Nullable String value, Field field) throws IllegalAccessException {
        Class<?> type = field.getType();
        if (type != String.class && value != null) {
            if (type == Long.TYPE || type == Long.class) {
                field.set(object, Long.parseLong(value));
            } else if (type == Integer.TYPE || type == Integer.class) {
                field.set(object, Integer.parseInt(value));
            } else if (type == UUID.class) {
                field.set(object, UUID.fromString(value));
            }
        } else {
            field.set(object, value);
        }
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonApiResourceIdentifier)) {
            return false;
        }
        JsonApiResourceIdentifier other = (JsonApiResourceIdentifier)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        Map<String, Object> this$meta = this.getMeta();
        Map<String, Object> other$meta = other.getMeta();
        return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        Map<String, Object> $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "JsonApiResourceIdentifier(id=" + this.getId() + ", type=" + this.getType() + ", meta=" + this.getMeta() + ")";
    }

    @JsonProperty
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @JsonProperty
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @JsonProperty
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiResourceIdentifier withId(String id) {
        return this.id == id ? this : new JsonApiResourceIdentifier(id, this.type, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiResourceIdentifier withType(String type) {
        return this.type == type ? this : new JsonApiResourceIdentifier(this.id, type, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiResourceIdentifier withMeta(Map<String, Object> meta) {
        return this.meta == meta ? this : new JsonApiResourceIdentifier(this.id, this.type, meta);
    }

    static enum JsonApiResourceField {
        ID,
        TYPE;

    }

    static class ResourceField {
        final String name;
        final String value;

        public ResourceField(String name, @Nullable String value) {
            this.name = name;
            this.value = value;
        }
    }
}

