/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiRelationshipSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiResourceIdentifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Links;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

@JsonPropertyOrder(value={"data", "links", "meta"})
@JsonSerialize(using=JsonApiRelationshipSerializer.class)
class JsonApiRelationship {
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    private final Object data;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    private final Links links;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @Nullable
    private final Map<String, Object> meta;
    @JsonIgnore
    private Map<Object, Map<String, Object>> metaForResourceIdentifiers;

    @JsonCreator
    JsonApiRelationship(@JsonProperty(value="data") @Nullable Object data, @JsonProperty(value="links") @Nullable Links links, @JsonProperty(value="meta") @Nullable Map<String, Object> meta, @Nullable Map<Object, Map<String, Object>> metaForResourceIdentifiers) {
        this.data = data;
        this.links = links;
        this.meta = meta;
        this.metaForResourceIdentifiers = metaForResourceIdentifiers;
    }

    @JsonCreator
    JsonApiRelationship(@JsonProperty(value="data") @Nullable Object data, @JsonProperty(value="links") @Nullable Links links, @JsonProperty(value="meta") @Nullable Map<String, Object> meta) {
        this(data, links, meta, null);
    }

    public JsonApiRelationship addDataObject(@Nullable Object object) {
        return this.addDataObject(object, null);
    }

    public JsonApiRelationship addDataObject(@Nullable Object object, @Nullable Map<String, Object> metaForResourceIdentifier) {
        if (metaForResourceIdentifier != null && !metaForResourceIdentifier.isEmpty()) {
            if (this.metaForResourceIdentifiers == null) {
                this.metaForResourceIdentifiers = new HashMap<Object, Map<String, Object>>();
            }
            this.metaForResourceIdentifiers.put(object, metaForResourceIdentifier);
        }
        if (this.data == null) {
            return new JsonApiRelationship(object, this.links, this.meta, this.metaForResourceIdentifiers);
        }
        ArrayList<Object> dataList = new ArrayList<Object>();
        Object object2 = this.data;
        if (!(object2 instanceof Collection)) {
            dataList.add(this.data);
        } else {
            Collection collection = (Collection)object2;
            dataList.addAll(collection);
        }
        dataList.add(object);
        return new JsonApiRelationship(dataList, this.links, this.meta, this.metaForResourceIdentifiers);
    }

    public JsonApiRelationship addDataCollection(Collection<?> collection) {
        if (this.data == null) {
            return new JsonApiRelationship(collection, this.links, this.meta, this.metaForResourceIdentifiers);
        }
        ArrayList<Object> dataList = new ArrayList<Object>();
        if (!(this.data instanceof Collection)) {
            dataList.add(this.data);
        } else {
            dataList.addAll((Collection)this.data);
        }
        dataList.addAll(collection);
        return new JsonApiRelationship(dataList, this.links, this.meta, this.metaForResourceIdentifiers);
    }

    public JsonApiRelationship isAlwaysSerializedWithDataArray() {
        if (this.data == null) {
            return new JsonApiRelationship(Collections.emptyList(), this.links, this.meta, this.metaForResourceIdentifiers);
        }
        if (!(this.data instanceof Collection)) {
            return new JsonApiRelationship(Collections.singletonList(this.data), this.links, this.meta, this.metaForResourceIdentifiers);
        }
        return this;
    }

    public static JsonApiRelationship of(EntityModel<?> entityModel) {
        Object content = entityModel.getContent();
        Assert.notNull((Object)content, (String)"Cannot create JSON:API relationship of EntityModel with null content.");
        return JsonApiRelationship.of(content);
    }

    public static JsonApiRelationship of(Object object) {
        return new JsonApiRelationship(object, null, null);
    }

    public static JsonApiRelationship of(@Nullable Object object, @Nullable Map<String, Object> resourceIdentifierMeta) {
        JsonApiRelationship jsonApiRelationship = new JsonApiRelationship(null, null, null);
        jsonApiRelationship = jsonApiRelationship.addDataObject(object, resourceIdentifierMeta);
        return jsonApiRelationship;
    }

    public static JsonApiRelationship of(Collection<?> collection) {
        return new JsonApiRelationship(collection, null, null);
    }

    public static JsonApiRelationship of(Links links) {
        return new JsonApiRelationship(null, links, null);
    }

    public static JsonApiRelationship of(Map<String, Object> meta) {
        return new JsonApiRelationship(null, null, meta);
    }

    @JsonIgnore
    public boolean isValid() {
        if (this.data == null && this.links == null && this.meta == null) {
            return true;
        }
        if (this.data != null) {
            JsonApiConfiguration jsonApiConfiguration = new JsonApiConfiguration();
            try {
                if (this.data instanceof Collection) {
                    for (Object jsonApiResource : (Collection)this.data) {
                        this.toJsonApiResource(jsonApiResource, jsonApiConfiguration);
                    }
                } else {
                    this.toJsonApiResource(this.data, jsonApiConfiguration);
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        if (this.links != null) {
            Optional selfLink = this.links.getLink("self");
            Optional relatedLink = this.links.getLink("related");
            return selfLink.isPresent() || relatedLink.isPresent();
        }
        return true;
    }

    JsonApiResourceIdentifier toJsonApiResource(Object data, JsonApiConfiguration jsonApiConfiguration) {
        Map<String, Object> localMeta = null;
        if (this.metaForResourceIdentifiers != null) {
            localMeta = this.metaForResourceIdentifiers.get(data);
        }
        String id = JsonApiResourceIdentifier.getId((Object)data, (JsonApiConfiguration)jsonApiConfiguration).value;
        String type = JsonApiResourceIdentifier.getType((Object)data, (JsonApiConfiguration)jsonApiConfiguration).value;
        return new JsonApiResourceIdentifier(id, type, localMeta);
    }

    List<JsonApiResourceIdentifier> toJsonApiResourceCollection(Collection<?> collection, JsonApiConfiguration jsonApiConfiguration) {
        ArrayList<JsonApiResourceIdentifier> dataList = new ArrayList<JsonApiResourceIdentifier>();
        HashMap<CallSite, JsonApiResourceIdentifier> values = new HashMap<CallSite, JsonApiResourceIdentifier>();
        for (Object object : collection) {
            JsonApiResourceIdentifier resourceIdentifier = this.toJsonApiResource(object, jsonApiConfiguration);
            if (values.get(resourceIdentifier.getId() + "." + resourceIdentifier.getType()) != null) continue;
            dataList.add(resourceIdentifier);
            values.put((CallSite)((Object)(resourceIdentifier.getId() + "." + resourceIdentifier.getType())), resourceIdentifier);
        }
        return dataList;
    }

    @Nullable
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Object getData() {
        return this.data;
    }

    @Nullable
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Links getLinks() {
        return this.links;
    }

    @Nullable
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<Object, Map<String, Object>> getMetaForResourceIdentifiers() {
        return this.metaForResourceIdentifiers;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiRelationship withData(@Nullable Object data) {
        return this.data == data ? this : new JsonApiRelationship(data, this.links, this.meta, this.metaForResourceIdentifiers);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiRelationship withLinks(@Nullable Links links) {
        return this.links == links ? this : new JsonApiRelationship(this.data, links, this.meta, this.metaForResourceIdentifiers);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiRelationship withMeta(@Nullable Map<String, Object> meta) {
        return this.meta == meta ? this : new JsonApiRelationship(this.data, this.links, meta, this.metaForResourceIdentifiers);
    }
}

