/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.toedter.spring.hateoas.jsonapi.AbstractJsonApiSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiAffordanceModel;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.MediaTypes;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.springframework.hateoas.Affordance;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.LinkRelation;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.QueryParameter;
import org.springframework.hateoas.mediatype.hal.forms.HalFormsTemplateBuilderWrapper;
import org.springframework.http.HttpMethod;
import org.springframework.web.util.UriUtils;

class JsonApiLinksSerializer
extends AbstractJsonApiSerializer<Links> {
    private static final ObjectMapper objectMapper = new ObjectMapper();
    private JsonApiConfiguration.AffordanceType affordanceType = JsonApiConfiguration.AffordanceType.NONE;
    private boolean removeHateoasLinkPropertiesFromMeta;

    public JsonApiLinksSerializer() {
        super(Links.class);
    }

    public void setJsonApiConfiguration(JsonApiConfiguration jsonApiConfiguration) {
        this.affordanceType = jsonApiConfiguration.getAffordancesRenderedAsLinkMeta();
        this.removeHateoasLinkPropertiesFromMeta = jsonApiConfiguration.isJsonApi11LinkPropertiesRemovedFromLinkMeta();
    }

    public void serialize(Links value, JsonGenerator gen, SerializerProvider provider) throws IOException {
        LinkedHashMap<LinkRelation, List> linksMap = new LinkedHashMap<LinkRelation, List>();
        for (Link link : value) {
            linksMap.computeIfAbsent(link.getRel(), key -> new ArrayList()).add(link);
        }
        gen.writeStartObject();
        for (Map.Entry entry : linksMap.entrySet()) {
            List list = (List)entry.getValue();
            if (list.size() != 1) continue;
            Link link = (Link)list.get(0);
            this.serializeLinkWithRelation(gen, link);
        }
        gen.writeEndObject();
    }

    private void serializeLinkWithRelation(JsonGenerator gen, Link link) throws IOException {
        if (this.isSimpleLink(link)) {
            gen.writeStringField(link.getRel().value(), UriUtils.encodeQuery((String)link.getHref(), (Charset)StandardCharsets.UTF_8));
        } else {
            gen.writeObjectFieldStart(link.getRel().value());
            this.writeComplexLink(gen, link);
            gen.writeEndObject();
        }
    }

    private void writeComplexLink(JsonGenerator gen, Link link) throws IOException {
        gen.writeStringField("href", UriUtils.encodeQuery((String)link.getHref(), (Charset)StandardCharsets.UTF_8));
        Map<String, Object> attributes = this.getAttributes(link);
        if (link.getTitle() != null) {
            gen.writeStringField("title", link.getTitle());
            if (this.removeHateoasLinkPropertiesFromMeta) {
                attributes.remove("title");
            }
        }
        if (link.getType() != null) {
            gen.writeStringField("type", link.getType());
            if (this.removeHateoasLinkPropertiesFromMeta) {
                attributes.remove("type");
            }
        }
        if (link.getHreflang() != null) {
            gen.writeStringField("hreflang", link.getHreflang());
            if (this.removeHateoasLinkPropertiesFromMeta) {
                attributes.remove("hreflang");
            }
        }
        gen.writeObjectField("meta", attributes);
    }

    private boolean isSimpleLink(Link link) {
        return this.getAttributes(link).size() == 0;
    }

    private Map<String, Object> getAttributes(Link link) {
        Map attributeMap = (Map)objectMapper.convertValue((Object)link, Map.class);
        attributeMap.remove("rel");
        attributeMap.remove("href");
        attributeMap.remove("template");
        attributeMap.remove("affordances");
        if (!link.getAffordances().isEmpty()) {
            ArrayList<SpringHateoasAffordance> affordanceList = new ArrayList<SpringHateoasAffordance>();
            for (Affordance affordance : link.getAffordances()) {
                Object halFormsTemplate;
                JsonApiAffordanceModel affordanceModel;
                if (this.affordanceType == JsonApiConfiguration.AffordanceType.SPRING_HATEOAS && (affordanceModel = (JsonApiAffordanceModel)affordance.getAffordanceModel(MediaTypes.JSON_API)) != null && affordanceModel.getHttpMethod() != HttpMethod.GET) {
                    String httpMethod = null;
                    if (affordanceModel.getHttpMethod() != null) {
                        httpMethod = affordanceModel.getHttpMethod().name();
                    }
                    SpringHateoasAffordance springHateoasAffordance = new SpringHateoasAffordance(affordanceModel.getName(), affordanceModel.getLink(), httpMethod, affordanceModel.getQueryMethodParameters(), affordanceModel.getInputProperties(), affordanceModel.getQueryProperties());
                    affordanceList.add(springHateoasAffordance);
                }
                if (this.affordanceType == JsonApiConfiguration.AffordanceType.HAL_FORMS && (affordanceModel = affordance.getAffordanceModel(org.springframework.hateoas.MediaTypes.HAL_FORMS_JSON)) != null && affordanceModel.getHttpMethod() != HttpMethod.GET && (halFormsTemplate = HalFormsTemplateBuilderWrapper.write(EntityModel.of((Object)new Object()).add(link))) != null) {
                    attributeMap.put("hal-forms-templates", halFormsTemplate);
                }
                if (affordanceList.isEmpty()) continue;
                attributeMap.put("affordances", affordanceList);
            }
        }
        if (link.isTemplated()) {
            attributeMap.put("isTemplated", true);
        }
        return attributeMap;
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    static class SpringHateoasAffordance {
        private final String name;
        private final Link link;
        private final String httpMethod;
        private final List<QueryParameter> queryMethodParameters;
        private final List<JsonApiAffordanceModel.PropertyData> inputProperties;
        private final List<JsonApiAffordanceModel.PropertyData> queryProperties;

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public SpringHateoasAffordance(String name, Link link, String httpMethod, List<QueryParameter> queryMethodParameters, List<JsonApiAffordanceModel.PropertyData> inputProperties, List<JsonApiAffordanceModel.PropertyData> queryProperties) {
            this.name = name;
            this.link = link;
            this.httpMethod = httpMethod;
            this.queryMethodParameters = queryMethodParameters;
            this.inputProperties = inputProperties;
            this.queryProperties = queryProperties;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getName() {
            return this.name;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public Link getLink() {
            return this.link;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public String getHttpMethod() {
            return this.httpMethod;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<QueryParameter> getQueryMethodParameters() {
            return this.queryMethodParameters;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<JsonApiAffordanceModel.PropertyData> getInputProperties() {
            return this.inputProperties;
        }

        @SuppressFBWarnings(justification="generated code")
        @Generated
        public List<JsonApiAffordanceModel.PropertyData> getQueryProperties() {
            return this.queryProperties;
        }
    }
}

