/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.databind.type.TypeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.lang.Nullable;

class JsonApiLinksDeserializer
extends ContainerDeserializerBase<Links> {
    private static final String HREFLANG = "hreflang";
    private static final String TITLE = "title";
    private static final String TYPE = "type";
    private static final String MEDIA = "media";
    private static final String DEPRECATION = "deprecation";
    private static final String PROFILE = "profile";
    private static final String NAME = "name";

    protected JsonApiLinksDeserializer() {
        super((JavaType)TypeFactory.defaultInstance().constructCollectionLikeType(List.class, Link.class));
    }

    @Nullable
    public JsonDeserializer<Object> getContentDeserializer() {
        return null;
    }

    public Links deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
        MapType type = ctxt.getTypeFactory().constructMapType(HashMap.class, String.class, Object.class);
        ArrayList links = new ArrayList();
        Map jsonApiLinks = (Map)jp.getCodec().readValue(jp, (ResolvedType)type);
        jsonApiLinks.forEach((rel, object) -> {
            if (object instanceof List) {
                for (Object linkObject : (List)object) {
                    this.deserializeLink(links, (String)rel, linkObject);
                }
            } else {
                this.deserializeLink(links, (String)rel, object);
            }
        });
        return Links.of(links);
    }

    private void deserializeLink(List<Link> links, String rel, Object linkObject) {
        if (linkObject instanceof String) {
            links.add(Link.of((String)linkObject.toString(), (String)rel));
        } else if (linkObject instanceof LinkedHashMap) {
            LinkedHashMap linkedHashMap = (LinkedHashMap)linkObject;
            Object href = linkedHashMap.get("href");
            Object meta = linkedHashMap.get("meta");
            if (href instanceof String) {
                Link link = Link.of((String)href.toString(), (String)rel);
                if (meta instanceof LinkedHashMap) {
                    LinkedHashMap linkedHashMapMeta;
                    LinkedHashMap attributes = linkedHashMapMeta = (LinkedHashMap)meta;
                    link = JsonApiLinksDeserializer.getLink(attributes, link);
                    if (attributes.containsKey(MEDIA)) {
                        link = link.withMedia((String)attributes.get(MEDIA));
                    }
                    if (attributes.containsKey(DEPRECATION)) {
                        link = link.withDeprecation((String)attributes.get(DEPRECATION));
                    }
                    if (attributes.containsKey(PROFILE)) {
                        link = link.withProfile((String)attributes.get(PROFILE));
                    }
                    if (attributes.containsKey(NAME)) {
                        link = link.withName((String)attributes.get(NAME));
                    }
                }
                link = JsonApiLinksDeserializer.getLink(linkedHashMap, link);
                links.add(link);
            }
        }
    }

    private static Link getLink(LinkedHashMap<?, ?> linkedHashMap, Link link) {
        if (linkedHashMap.containsKey(HREFLANG)) {
            link = link.withHreflang(linkedHashMap.get(HREFLANG).toString());
        }
        if (linkedHashMap.containsKey(TITLE)) {
            link = link.withTitle(linkedHashMap.get(TITLE).toString());
        }
        if (linkedHashMap.containsKey(TYPE)) {
            link = link.withType(linkedHashMap.get(TYPE).toString());
        }
        return link;
    }
}

