/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

@JsonPropertyOrder(value={"id", "links", "status", "code", "title", "detail", "source", "meta"})
@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public final class JsonApiError {
    private static final JsonApiError EMPTY = new JsonApiError();
    private static final String POINTER = "pointer";
    private static final String PARAMETER = "parameter";
    private final String id;
    private final Map<String, String> links;
    private final String status;
    private final String code;
    private final String title;
    private final String detail;
    private final Map<String, String> source;
    private final Map<String, Object> meta;

    public JsonApiError withSourcePointer(String sourcePointer) {
        HashMap<String, String> localSource = new HashMap<String, String>();
        if (this.source != null && this.source.get(PARAMETER) != null) {
            localSource.put(PARAMETER, this.source.get(PARAMETER));
        }
        localSource.put(POINTER, sourcePointer);
        return new JsonApiError(this.id, this.links, this.status, this.code, this.title, this.detail, localSource, this.meta);
    }

    public JsonApiError withSourceParameter(String sourceParameter) {
        HashMap<String, String> localSource = new HashMap<String, String>();
        if (this.source != null && this.source.get(POINTER) != null) {
            localSource.put(POINTER, this.source.get(POINTER));
        }
        localSource.put(PARAMETER, sourceParameter);
        return new JsonApiError(this.id, this.links, this.status, this.code, this.title, this.detail, localSource, this.meta);
    }

    public JsonApiError withAboutLink(String aboutLink) {
        HashMap<String, String> localLinks = new HashMap<String, String>();
        localLinks.put("about", aboutLink);
        return new JsonApiError(this.id, localLinks, this.status, this.code, this.title, this.detail, this.source, this.meta);
    }

    public JsonApiError() {
        this(null, null, null, null, null, null, null, null);
    }

    public static JsonApiError create() {
        return EMPTY;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonApiError)) {
            return false;
        }
        JsonApiError other = (JsonApiError)o;
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Map<String, String> this$links = this.getLinks();
        Map<String, String> other$links = other.getLinks();
        if (this$links == null ? other$links != null : !((Object)this$links).equals(other$links)) {
            return false;
        }
        String this$status = this.getStatus();
        String other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$detail = this.getDetail();
        String other$detail = other.getDetail();
        if (this$detail == null ? other$detail != null : !this$detail.equals(other$detail)) {
            return false;
        }
        Map<String, String> this$source = this.getSource();
        Map<String, String> other$source = other.getSource();
        if (this$source == null ? other$source != null : !((Object)this$source).equals(other$source)) {
            return false;
        }
        Map<String, Object> this$meta = this.getMeta();
        Map<String, Object> other$meta = other.getMeta();
        return !(this$meta == null ? other$meta != null : !((Object)this$meta).equals(other$meta));
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Map<String, String> $links = this.getLinks();
        result = result * 59 + ($links == null ? 43 : ((Object)$links).hashCode());
        String $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $detail = this.getDetail();
        result = result * 59 + ($detail == null ? 43 : $detail.hashCode());
        Map<String, String> $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : ((Object)$source).hashCode());
        Map<String, Object> $meta = this.getMeta();
        result = result * 59 + ($meta == null ? 43 : ((Object)$meta).hashCode());
        return result;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "JsonApiError(id=" + this.getId() + ", links=" + this.getLinks() + ", status=" + this.getStatus() + ", code=" + this.getCode() + ", title=" + this.getTitle() + ", detail=" + this.getDetail() + ", source=" + this.getSource() + ", meta=" + this.getMeta() + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiError(String id, Map<String, String> links, String status, String code, String title, String detail, Map<String, String> source, Map<String, Object> meta) {
        this.id = id;
        this.links = links;
        this.status = status;
        this.code = code;
        this.title = title;
        this.detail = detail;
        this.source = source;
        this.meta = meta;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiError withId(String id) {
        return this.id == id ? this : new JsonApiError(id, this.links, this.status, this.code, this.title, this.detail, this.source, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getLinks() {
        return this.links;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getStatus() {
        return this.status;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiError withStatus(String status) {
        return this.status == status ? this : new JsonApiError(this.id, this.links, status, this.code, this.title, this.detail, this.source, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getCode() {
        return this.code;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiError withCode(String code) {
        return this.code == code ? this : new JsonApiError(this.id, this.links, this.status, code, this.title, this.detail, this.source, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getTitle() {
        return this.title;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiError withTitle(String title) {
        return this.title == title ? this : new JsonApiError(this.id, this.links, this.status, this.code, title, this.detail, this.source, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getDetail() {
        return this.detail;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiError withDetail(String detail) {
        return this.detail == detail ? this : new JsonApiError(this.id, this.links, this.status, this.code, this.title, detail, this.source, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, String> getSource() {
        return this.source;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public JsonApiError withMeta(Map<String, Object> meta) {
        return this.meta == meta ? this : new JsonApiError(this.id, this.links, this.status, this.code, this.title, this.detail, this.source, meta);
    }
}

