/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.toedter.spring.hateoas.jsonapi.AbstractJsonApiModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiData;
import com.toedter.spring.hateoas.jsonapi.JsonApiDocument;
import com.toedter.spring.hateoas.jsonapi.JsonApiMeta;
import com.toedter.spring.hateoas.jsonapi.JsonApiRelationships;
import com.toedter.spring.hateoas.jsonapi.ReflectionUtils;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Links;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

class JsonApiEntityModelDeserializer
extends AbstractJsonApiModelDeserializer<EntityModel<?>>
implements ContextualDeserializer {
    public static final String CANNOT_DESERIALIZE_INPUT_TO_ENTITY_MODEL = "Cannot deserialize input to EntityModel";

    public JsonApiEntityModelDeserializer(JsonApiConfiguration jsonApiConfiguration) {
        super(jsonApiConfiguration);
    }

    protected JsonApiEntityModelDeserializer(JavaType contentType, JsonApiConfiguration jsonApiConfiguration) {
        super(contentType, jsonApiConfiguration);
    }

    @Override
    protected EntityModel<?> convertToRepresentationModel(List<Object> resources, JsonApiDocument doc) {
        Assert.notNull((Object)doc, (String)"JsonApiDocument must not be null!");
        Links links = doc.getLinks();
        if (resources.size() == 1) {
            Object meta;
            EntityModel entityModel = EntityModel.of((Object)resources.get(0));
            if (links != null) {
                entityModel.add((Iterable)links);
            }
            if (doc.getData() == null) {
                return entityModel;
            }
            HashMap relationships = (HashMap)((HashMap)doc.getData()).get("relationships");
            Object content = entityModel.getContent();
            if (relationships != null) {
                Field[] declaredFields = ReflectionUtils.getAllDeclaredFields(content.getClass());
                for (Field field : declaredFields) {
                    field.setAccessible(true);
                    JsonApiRelationships relationshipsAnnotation = field.getAnnotation(JsonApiRelationships.class);
                    if (relationshipsAnnotation == null) continue;
                    Object relationship = relationships.get(relationshipsAnnotation.value());
                    try {
                        if (relationship == null) continue;
                        Type genericType = field.getGenericType();
                        if (genericType instanceof ParameterizedType) {
                            ParameterizedType parameterizedType;
                            ParameterizedType type = parameterizedType = (ParameterizedType)genericType;
                            if (!Collection.class.isAssignableFrom(field.getType())) continue;
                            AbstractCollection relationshipCollection = Set.class.isAssignableFrom(field.getType()) ? new HashSet() : new ArrayList();
                            Object data = ((HashMap)relationship).get("data");
                            List<HashMap> jsonApiRelationships = null;
                            if (data instanceof List) {
                                jsonApiRelationships = (List<HashMap>)data;
                            } else if (data instanceof HashMap) {
                                HashMap castedData = (HashMap)data;
                                jsonApiRelationships = Collections.singletonList(castedData);
                            } else if (data != null) {
                                throw new IllegalArgumentException(CANNOT_DESERIALIZE_INPUT_TO_ENTITY_MODEL);
                            }
                            if (data != null) {
                                Type typeArgument = type.getActualTypeArguments()[0];
                                for (HashMap entry : jsonApiRelationships) {
                                    Object newInstance = this.createRelationship(doc, typeArgument, entry).getContent();
                                    relationshipCollection.add(newInstance);
                                }
                            }
                            field.set(content, relationshipCollection);
                            continue;
                        }
                        HashMap data = (HashMap)((HashMap)relationship).get("data");
                        Object newInstance = this.createRelationship(doc, genericType, data).getContent();
                        field.set(content, newInstance);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException(CANNOT_DESERIALIZE_INPUT_TO_ENTITY_MODEL, e);
                    }
                }
            }
            if ((meta = ((HashMap)doc.getData()).get("meta")) != null) {
                for (Field field : ReflectionUtils.getAllDeclaredFields(content.getClass())) {
                    if (field.getAnnotation(JsonApiMeta.class) == null) continue;
                    try {
                        Object metaValue;
                        field.setAccessible(true);
                        if (!(meta instanceof Map) || (metaValue = ((Map)meta).get(field.getName())) == null) continue;
                        field.set(content, metaValue);
                    }
                    catch (IllegalAccessException e) {
                        throw new IllegalArgumentException("Cannot set JSON:API meta data for annotated field: " + field.getName(), e);
                    }
                }
                for (AccessibleObject accessibleObject : content.getClass().getDeclaredMethods()) {
                    if (((Method)accessibleObject).getAnnotation(JsonApiMeta.class) == null) continue;
                    try {
                        Object metaValue;
                        ((Method)accessibleObject).setAccessible(true);
                        if (((Method)accessibleObject).getReturnType() != Void.TYPE || !(meta instanceof Map)) continue;
                        String methodName = ((Method)accessibleObject).getName();
                        if (methodName.startsWith("set")) {
                            methodName = StringUtils.uncapitalize((String)methodName.substring(3));
                        }
                        if ((metaValue = ((Map)meta).get(methodName)) == null) continue;
                        ((Method)accessibleObject).invoke(content, metaValue);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Cannot set JSON:API meta data for annotated method: " + ((Method)accessibleObject).getName(), e);
                    }
                }
            }
            return entityModel;
        }
        throw new IllegalArgumentException(CANNOT_DESERIALIZE_INPUT_TO_ENTITY_MODEL);
    }

    @Nullable
    private EntityModel<?> createRelationship(JsonApiDocument doc, Type typeArgument, HashMap<String, Object> entry) {
        String id = entry.get("id").toString();
        String jsonApiType = entry.get("type").toString();
        if (doc != null && doc.getIncluded() != null) {
            Map<String, Object> relationships;
            Map<String, Object> attributes = this.findIncludedAttributesForRelationshipObject(id, jsonApiType, doc);
            if (attributes != null) {
                entry.put("attributes", attributes);
            }
            if ((relationships = this.findIncludedRelationshipsForRelationshipObject(id, jsonApiType, doc)) != null) {
                entry.put("relationships", relationships);
            }
        }
        return (EntityModel)this.convertToResource(entry, true, doc, this.objectMapper.constructType(typeArgument), true);
    }

    @Override
    protected JsonDeserializer<?> createJsonDeserializer(JavaType type) {
        return new JsonApiEntityModelDeserializer(type, this.jsonApiConfiguration);
    }

    @Nullable
    protected Map<String, Object> findIncludedAttributesForRelationshipObject(String id, String type, JsonApiDocument doc) {
        for (JsonApiData jsonApiData : doc.getIncluded()) {
            if (!id.equals(jsonApiData.getId()) || !type.equals(jsonApiData.getType())) continue;
            return jsonApiData.getAttributes();
        }
        return null;
    }

    @Nullable
    protected Map<String, Object> findIncludedRelationshipsForRelationshipObject(String id, String type, JsonApiDocument doc) {
        for (JsonApiData jsonApiData : doc.getIncluded()) {
            if (!id.equals(jsonApiData.getId()) || !type.equals(jsonApiData.getType())) continue;
            return (Map)jsonApiData.getRelationships();
        }
        return null;
    }
}

