/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiMeta;
import com.toedter.spring.hateoas.jsonapi.JsonApiModel;
import com.toedter.spring.hateoas.jsonapi.JsonApiRelationship;
import com.toedter.spring.hateoas.jsonapi.JsonApiResourceIdentifier;
import com.toedter.spring.hateoas.jsonapi.JsonApiTypeForClass;
import com.toedter.spring.hateoas.jsonapi.ReflectionUtils;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import lombok.Generated;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
class JsonApiData {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = Logger.getLogger(JsonApiData.class.getName());
    String id;
    String type;
    Map<String, Object> attributes;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    Object relationships;
    Links links;
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    Map<String, Object> meta;
    static final HashSet<Class<?>> RESOURCE_TYPES = new HashSet<Class>(Arrays.asList(RepresentationModel.class, EntityModel.class, CollectionModel.class, PagedModel.class));

    @JsonCreator
    public JsonApiData(@JsonProperty(value="id") @Nullable String id, @JsonProperty(value="type") @Nullable String type, @JsonProperty(value="attributes") @Nullable Map<String, Object> attributes, @JsonProperty(value="relationships") @Nullable Object relationships, @JsonProperty(value="links") @Nullable Links links, @JsonProperty(value="meta") @Nullable Map<String, Object> meta) {
        this.id = id;
        this.type = type;
        this.attributes = attributes;
        this.relationships = relationships;
        this.links = links;
        this.meta = meta;
    }

    public static List<JsonApiData> extractCollectionContent(CollectionModel<?> collectionModel, ObjectMapper objectMapper, JsonApiConfiguration jsonApiConfiguration, @Nullable Map<String, Collection<String>> sparseFieldsets, boolean eliminateDuplicates) {
        if (eliminateDuplicates) {
            HashMap values = new HashMap();
            for (Object entity : collectionModel.getContent()) {
                Optional<JsonApiData> jsonApiData = JsonApiData.extractContent(entity, false, objectMapper, jsonApiConfiguration, sparseFieldsets);
                jsonApiData.ifPresent(apiData -> values.put(apiData.getId() + "." + apiData.getType(), apiData));
            }
            return new ArrayList<JsonApiData>(values.values());
        }
        ArrayList<JsonApiData> dataList = new ArrayList<JsonApiData>();
        for (Object entity : collectionModel.getContent()) {
            Optional<JsonApiData> jsonApiData = JsonApiData.extractContent(entity, false, objectMapper, jsonApiConfiguration, sparseFieldsets);
            jsonApiData.ifPresent(dataList::add);
        }
        return dataList;
    }

    public static Optional<JsonApiData> extractContent(@Nullable Object content, boolean isSingleEntity, ObjectMapper objectMapper, JsonApiConfiguration jsonApiConfiguration, @Nullable Map<String, Collection<String>> sparseFieldsets) {
        Object attributes;
        Links links = null;
        Map<String, JsonApiRelationship> relationships = null;
        Map<String, Object> metaData = null;
        if (content instanceof RepresentationModel) {
            links = ((RepresentationModel)content).getLinks();
        }
        if (content instanceof JsonApiModel) {
            JsonApiModel jsonApiModel = (JsonApiModel)content;
            relationships = jsonApiModel.getRelationships();
            sparseFieldsets = jsonApiModel.getSparseFieldsets();
            metaData = jsonApiModel.getMetaData();
            content = jsonApiModel.getContent();
        }
        if (content instanceof EntityModel) {
            content = ((EntityModel)content).getContent();
        }
        if (content == null) {
            return Optional.empty();
        }
        Field[] fields = ReflectionUtils.getAllDeclaredFields(content.getClass());
        boolean validFieldFound = false;
        for (Field field : fields) {
            if ("$jacocoData".equals(field.getName()) || "__$lineHits$__".equals(field.getName()) || content instanceof RepresentationModel && "links".equals(field.getName())) continue;
            validFieldFound = true;
            break;
        }
        if (!validFieldFound) {
            return Optional.empty();
        }
        JsonApiResourceIdentifier.ResourceField idField = JsonApiResourceIdentifier.getId(content, jsonApiConfiguration);
        if (isSingleEntity || links != null && links.isEmpty()) {
            links = null;
        }
        if (jsonApiConfiguration.isJsonApiCompliantLinks() && links != null) {
            Links validJsonApiLinks = Links.NONE;
            for (Link link : links) {
                if (link.hasRel("self")) {
                    validJsonApiLinks = validJsonApiLinks.and(new Link[]{link});
                    continue;
                }
                log.warning("removed invalid JSON:API resource-level link: " + link.getRel());
            }
            links = validJsonApiLinks;
        }
        JsonApiResourceIdentifier.ResourceField typeField = JsonApiResourceIdentifier.getType(content, jsonApiConfiguration);
        JavaType mapType = objectMapper.getTypeFactory().constructParametricType(Map.class, new Class[]{String.class, Object.class});
        Map attributeMap = (Map)objectMapper.convertValue(content, mapType);
        attributeMap.remove("links");
        attributeMap.remove(idField.name);
        if (jsonApiConfiguration.getJsonApiIdNotSerializedForValue() != null && jsonApiConfiguration.getJsonApiIdNotSerializedForValue().equals(idField.value)) {
            idField = new JsonApiResourceIdentifier.ResourceField(idField.name, null);
        }
        if (!content.getClass().isAnnotationPresent(JsonApiTypeForClass.class)) {
            attributeMap.remove(typeField.name);
        }
        Links finalLinks = links;
        String finalId = idField.value;
        String finalType = typeField.value;
        Map<String, JsonApiRelationship> finalRelationships = relationships;
        if (sparseFieldsets != null && (attributes = sparseFieldsets.get(finalType)) != null) {
            HashSet keys = new HashSet(attributeMap.keySet());
            for (String key : keys) {
                if (attributes.contains(key)) continue;
                attributeMap.remove(key);
            }
        }
        for (Field field : ReflectionUtils.getAllDeclaredFields(content.getClass())) {
            if (field.getAnnotation(JsonApiMeta.class) == null || !attributeMap.containsKey(field.getName())) continue;
            attributeMap.remove(field.getName());
            try {
                field.setAccessible(true);
                if (metaData == null) {
                    metaData = new LinkedHashMap<String, Object>();
                }
                metaData.put(field.getName(), field.get(content));
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException("Cannot get JSON:API meta data from annotated property: " + field.getName(), e);
            }
        }
        for (Method method : content.getClass().getMethods()) {
            if (method.getAnnotation(JsonApiMeta.class) == null) continue;
            try {
                String methodName = method.getName();
                if (methodName.startsWith("get")) {
                    methodName = StringUtils.uncapitalize((String)methodName.substring(3));
                }
                if (!attributeMap.containsKey(methodName)) continue;
                method.setAccessible(true);
                if (metaData == null) {
                    metaData = new LinkedHashMap<String, Object>();
                }
                if (method.getReturnType() == Void.TYPE) continue;
                attributeMap.remove(methodName);
                metaData.put(methodName, method.invoke(content, new Object[0]));
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot get JSON:API meta data from annotated method: " + method.getName(), e);
            }
        }
        Map<String, Object> finalMetaData = metaData;
        JsonApiData jsonApiData = new JsonApiData(finalId, finalType, attributeMap, finalRelationships, finalLinks, finalMetaData);
        if (!attributeMap.isEmpty() || jsonApiConfiguration.isEmptyAttributesObjectSerialized()) {
            return Optional.of(content).filter(it -> !RESOURCE_TYPES.contains(it.getClass())).map(it -> jsonApiData);
        }
        return Optional.of(content).filter(it -> !RESOURCE_TYPES.contains(it.getClass())).map(it -> new JsonApiDataWithoutSerializedAttributes(jsonApiData));
    }

    @JsonProperty
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getId() {
        return this.id;
    }

    @JsonProperty
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String getType() {
        return this.type;
    }

    @JsonProperty
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @JsonProperty
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Object getRelationships() {
        return this.relationships;
    }

    @JsonProperty
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Links getLinks() {
        return this.links;
    }

    @JsonProperty
    @SuppressFBWarnings(justification="generated code")
    @Generated
    public Map<String, Object> getMeta() {
        return this.meta;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiData withId(String id) {
        return this.id == id ? this : new JsonApiData(id, this.type, this.attributes, this.relationships, this.links, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiData withType(String type) {
        return this.type == type ? this : new JsonApiData(this.id, type, this.attributes, this.relationships, this.links, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiData withAttributes(Map<String, Object> attributes) {
        return this.attributes == attributes ? this : new JsonApiData(this.id, this.type, attributes, this.relationships, this.links, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiData withRelationships(Object relationships) {
        return this.relationships == relationships ? this : new JsonApiData(this.id, this.type, this.attributes, relationships, this.links, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiData withLinks(Links links) {
        return this.links == links ? this : new JsonApiData(this.id, this.type, this.attributes, this.relationships, links, this.meta);
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    JsonApiData withMeta(Map<String, Object> meta) {
        return this.meta == meta ? this : new JsonApiData(this.id, this.type, this.attributes, this.relationships, this.links, meta);
    }

    private static class JsonApiDataWithoutSerializedAttributes
    extends JsonApiData {
        JsonApiDataWithoutSerializedAttributes(JsonApiData jsonApiData) {
            super(jsonApiData.id, jsonApiData.type, null, jsonApiData.relationships, jsonApiData.links, jsonApiData.meta);
        }

        @Override
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        @Nullable
        public Map<String, Object> getAttributes() {
            return null;
        }
    }
}

