/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.toedter.spring.hateoas.jsonapi.AbstractJsonApiModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiDocument;
import java.util.List;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.Links;

class JsonApiCollectionModelDeserializer
extends AbstractJsonApiModelDeserializer<CollectionModel<?>>
implements ContextualDeserializer {
    JsonApiCollectionModelDeserializer(JsonApiConfiguration jsonApiConfiguration) {
        super(jsonApiConfiguration);
    }

    protected JsonApiCollectionModelDeserializer(JavaType contentType, JsonApiConfiguration jsonApiConfiguration) {
        super(contentType, jsonApiConfiguration);
    }

    @Override
    protected CollectionModel<?> convertToRepresentationModel(List<Object> resources, JsonApiDocument doc) {
        Links links = doc.getLinks();
        if (links == null) {
            return CollectionModel.of(resources);
        }
        return CollectionModel.of(resources, (Iterable)links);
    }

    @Override
    protected JsonDeserializer<?> createJsonDeserializer(JavaType type) {
        return new JsonApiCollectionModelDeserializer(type, this.jsonApiConfiguration);
    }
}

