/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.toedter.spring.hateoas.jsonapi.JsonApiCollectionModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiCollectionModelSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiEntityModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiEntityModelSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiLinksDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiLinksSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiPagedModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiPagedModelSerializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiRepresentationModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiRepresentationModelSerializer;
import org.springframework.hateoas.CollectionModel;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.RepresentationModel;
import org.springframework.lang.Nullable;

public class Jackson2JsonApiModule
extends SimpleModule {
    public Jackson2JsonApiModule(@Nullable JsonApiConfiguration jsonApiConfiguration) {
        super("json-api-module", new Version(2, 0, 0, null, "com.toedter", "spring-hateoas-jsonapi"));
        this.setMixInAnnotation(EntityModel.class, EntityModelMixin.class);
        this.setMixInAnnotation(RepresentationModel.class, RepresentationModelMixin.class);
        this.setMixInAnnotation(CollectionModel.class, CollectionModelMixin.class);
        this.setMixInAnnotation(PagedModel.class, PagedModelMixin.class);
        JsonApiLinksSerializer jsonApiLinksSerializer = new JsonApiLinksSerializer();
        if (jsonApiConfiguration != null) {
            jsonApiLinksSerializer.setJsonApiConfiguration(jsonApiConfiguration);
        }
        this.addSerializer(Links.class, (JsonSerializer)jsonApiLinksSerializer);
        this.addDeserializer(Links.class, (JsonDeserializer)new JsonApiLinksDeserializer());
    }

    public Jackson2JsonApiModule() {
        this(null);
    }

    @JsonSerialize(using=JsonApiEntityModelSerializer.class)
    @JsonDeserialize(using=JsonApiEntityModelDeserializer.class)
    static abstract class EntityModelMixin<T>
    extends EntityModel<T> {
        EntityModelMixin() {
        }
    }

    @JsonSerialize(using=JsonApiRepresentationModelSerializer.class)
    @JsonDeserialize(using=JsonApiRepresentationModelDeserializer.class)
    static abstract class RepresentationModelMixin
    extends RepresentationModel<RepresentationModelMixin> {
        RepresentationModelMixin() {
        }
    }

    @JsonSerialize(using=JsonApiCollectionModelSerializer.class)
    @JsonDeserialize(using=JsonApiCollectionModelDeserializer.class)
    static abstract class CollectionModelMixin<T>
    extends CollectionModel<T> {
        CollectionModelMixin() {
        }
    }

    @JsonSerialize(using=JsonApiPagedModelSerializer.class)
    @JsonDeserialize(using=JsonApiPagedModelDeserializer.class)
    static abstract class PagedModelMixin<T>
    extends PagedModel<T> {
        PagedModelMixin() {
        }
    }
}

