/*
 * Decompiled with CFR 0.152.
 */
package com.toedter.spring.hateoas.jsonapi;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.toedter.spring.hateoas.jsonapi.JsonApiCollectionModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiConfiguration;
import com.toedter.spring.hateoas.jsonapi.JsonApiDocument;
import com.toedter.spring.hateoas.jsonapi.JsonApiEntityModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiPagedModelDeserializer;
import com.toedter.spring.hateoas.jsonapi.JsonApiResourceIdentifier;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Links;
import org.springframework.hateoas.mediatype.JacksonHelper;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

abstract class AbstractJsonApiModelDeserializer<T>
extends ContainerDeserializerBase<T>
implements ContextualDeserializer {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractJsonApiModelDeserializer.class);
    protected final ObjectMapper objectMapper;
    protected final JavaType contentType;
    protected final transient JsonApiConfiguration jsonApiConfiguration;
    private final ObjectMapper plainObjectMapper;

    AbstractJsonApiModelDeserializer(JsonApiConfiguration jsonApiConfiguration) {
        this(TypeFactory.defaultInstance().constructSimpleType(JsonApiDocument.class, new JavaType[0]), jsonApiConfiguration);
    }

    protected AbstractJsonApiModelDeserializer(JavaType contentType, JsonApiConfiguration jsonApiConfiguration) {
        super(contentType);
        this.contentType = contentType;
        this.jsonApiConfiguration = jsonApiConfiguration;
        this.objectMapper = jsonApiConfiguration.getObjectMapper();
        this.plainObjectMapper = new ObjectMapper();
        jsonApiConfiguration.customize(this.plainObjectMapper);
    }

    public T deserialize(JsonParser p, DeserializationContext ctxt) throws IOException {
        JsonApiDocument doc;
        JavaType javaType;
        boolean isEntityModelCollection = false;
        if ((this instanceof JsonApiPagedModelDeserializer || this instanceof JsonApiCollectionModelDeserializer) && (javaType = this.contentType.containedType(0)).getRawClass() == EntityModel.class) {
            isEntityModelCollection = true;
        }
        if ((doc = (JsonApiDocument)p.getCodec().readValue(p, JsonApiDocument.class)).getData() instanceof Collection) {
            boolean isEntityModelCollectionFinal = isEntityModelCollection;
            List collection = (List)doc.getData();
            Assert.notNull((Object)collection, (String)"JsonApiDocument data must not be null!");
            List<Object> resources = collection.stream().map(data -> this.convertToResource((HashMap<String, Object>)data, isEntityModelCollectionFinal, doc, null, false)).toList();
            return this.convertToRepresentationModel(resources, doc);
        }
        HashMap data2 = (HashMap)doc.getData();
        Object objectFromProperties = this.convertToResource(data2, false, doc, null, false);
        return this.convertToRepresentationModel(Collections.singletonList(objectFromProperties), doc);
    }

    public JavaType getContentType() {
        return this.contentType;
    }

    @Nullable
    public JsonDeserializer<Object> getContentDeserializer() {
        return null;
    }

    public JsonDeserializer<?> createContextual(DeserializationContext ctxt, @Nullable BeanProperty property) {
        JavaType type = property == null ? ctxt.getContextualType() : property.getType().getContentType();
        return this.createJsonDeserializer(type);
    }

    @Nullable
    protected Object convertToResource(@Nullable HashMap<String, Object> data, boolean wrapInEntityModel, @Nullable JsonApiDocument doc, @Nullable JavaType javaType, boolean useDataForCreation) {
        Object objectFromProperties;
        String jsonApiType;
        if (data == null) {
            return null;
        }
        Map attributes = (Map)data.get("attributes");
        JavaType rootType = javaType;
        if (rootType == null) {
            rootType = JacksonHelper.findRootType((JavaType)this.contentType);
        }
        Class<?> clazz = null;
        if (this.jsonApiConfiguration.isTypeForClassUsedForDeserialization() && (jsonApiType = (String)data.get("type")) != null) {
            clazz = this.jsonApiConfiguration.getClassForType(jsonApiType);
            if (clazz != null && !rootType.getRawClass().isAssignableFrom(clazz)) {
                throw new IllegalArgumentException(clazz + " is not assignable to " + rootType.getRawClass());
            }
            if (clazz != null) {
                rootType = this.objectMapper.constructType(clazz);
            }
        }
        if (attributes != null) {
            objectFromProperties = this.plainObjectMapper.convertValue((Object)attributes, rootType);
        } else {
            try {
                if (useDataForCreation) {
                    objectFromProperties = this.objectMapper.convertValue(data, rootType);
                } else {
                    if (clazz == null) {
                        clazz = rootType.getRawClass();
                    }
                    objectFromProperties = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Cannot convert data to resource.");
            }
        }
        JsonApiResourceIdentifier.setJsonApiResourceFieldAttributeForObject(objectFromProperties, JsonApiResourceIdentifier.JsonApiResourceField.ID, (String)data.get("id"));
        JsonApiResourceIdentifier.setJsonApiResourceFieldAttributeForObject(objectFromProperties, JsonApiResourceIdentifier.JsonApiResourceField.TYPE, (String)data.get("type"));
        if (wrapInEntityModel) {
            Links links = (Links)this.objectMapper.convertValue(data.get("links"), Links.class);
            if (links == null) {
                links = Links.NONE;
            }
            JsonApiEntityModelDeserializer jsonApiEntityModelDeserializer = new JsonApiEntityModelDeserializer(this.jsonApiConfiguration);
            JsonApiDocument jsonApiDocument = new JsonApiDocument(null, data, null, null, links, doc != null ? doc.getIncluded() : null);
            return jsonApiEntityModelDeserializer.convertToRepresentationModel(Collections.singletonList(objectFromProperties), jsonApiDocument);
        }
        return objectFromProperties;
    }

    protected abstract T convertToRepresentationModel(List<Object> var1, JsonApiDocument var2);

    protected abstract JsonDeserializer<?> createJsonDeserializer(JavaType var1);
}

