/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal;

import com.tngtech.java.junit.dataprovider.DataProvider;
import com.tngtech.java.junit.dataprovider.UseDataProvider;
import com.tngtech.java.junit.dataprovider.internal.DataConverter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.List;
import org.junit.runners.model.FrameworkMethod;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestValidator {
    private final DataConverter dataConverter;

    public TestValidator(DataConverter dataConverter) {
        if (dataConverter == null) {
            throw new NullPointerException("dataConverter must not be null");
        }
        this.dataConverter = dataConverter;
    }

    public void validateTestMethod(FrameworkMethod testMethod, List<Throwable> errors) {
        if (testMethod == null) {
            throw new NullPointerException("testMethod must not be null");
        }
        if (errors == null) {
            throw new NullPointerException("errors must not be null");
        }
        UseDataProvider useDataProvider = (UseDataProvider)testMethod.getAnnotation(UseDataProvider.class);
        DataProvider dataProvider = (DataProvider)testMethod.getAnnotation(DataProvider.class);
        if (useDataProvider != null && dataProvider != null) {
            errors.add(new Exception(String.format("Method %s() should either have @%s or @%s annotation", testMethod.getName(), useDataProvider.getClass().getSimpleName(), dataProvider.getClass().getSimpleName())));
        } else if (useDataProvider == null && dataProvider == null) {
            testMethod.validatePublicVoidNoArg(false, errors);
        } else {
            testMethod.validatePublicVoid(false, errors);
            if (testMethod.getMethod().getParameterTypes().length <= 0) {
                errors.add(new Exception(String.format("Method %s() must have at least one argument for data provider", testMethod.getName())));
            }
        }
    }

    public void validateDataProviderMethod(FrameworkMethod dataProviderMethod, DataProvider dataProvider, List<Throwable> errors) {
        if (dataProviderMethod == null) {
            throw new NullPointerException("dataProviderMethod must not be null");
        }
        if (dataProvider == null) {
            throw new NullPointerException("dataProvider must not be null");
        }
        if (errors == null) {
            throw new NullPointerException("errors must not be null");
        }
        Method method = dataProviderMethod.getMethod();
        String messageBasePart = "Data provider method '" + dataProviderMethod.getName() + "' must";
        if (!Modifier.isPublic(method.getModifiers())) {
            errors.add(new Exception(messageBasePart + " be public"));
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            errors.add(new Exception(messageBasePart + " be static"));
        }
        if (!(method.getParameterTypes().length == 0 || method.getParameterTypes().length == 1 && method.getParameterTypes()[0].equals(FrameworkMethod.class))) {
            errors.add(new Exception(messageBasePart + " either have a single FrameworkMethod parameter or none"));
        }
        if (!this.dataConverter.canConvert(method.getGenericReturnType())) {
            errors.add(new Exception(messageBasePart + " either return Object[][] or List<List<Object>>"));
        }
        if (dataProvider.value().length > 0) {
            errors.add(new Exception(messageBasePart + " not define @DataProvider.value()"));
        }
    }
}

