/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider.internal;

import java.util.Arrays;

public class ParametersFormatter {
    public String format(Object[] parameters) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < parameters.length; ++i) {
            Object param = parameters[i];
            if (param == null) {
                stringBuilder.append("<null>");
            } else if (param.getClass().isArray()) {
                if (param.getClass().getComponentType().isPrimitive()) {
                    this.appendTo(stringBuilder, param);
                } else {
                    stringBuilder.append('[').append(this.format((Object[])param)).append(']');
                }
            } else if (param instanceof String && ((String)param).isEmpty()) {
                stringBuilder.append("<empty string>");
            } else {
                stringBuilder.append(param.toString());
            }
            if (i >= parameters.length - 1) continue;
            stringBuilder.append(", ");
        }
        return stringBuilder.toString();
    }

    private void appendTo(StringBuilder stringBuilder, Object primitiveArray) {
        Class<?> componentType = primitiveArray.getClass().getComponentType();
        if (Boolean.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((boolean[])primitiveArray));
        } else if (Byte.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((byte[])primitiveArray));
        } else if (Character.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((char[])primitiveArray));
        } else if (Short.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((short[])primitiveArray));
        } else if (Integer.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((int[])primitiveArray));
        } else if (Long.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((long[])primitiveArray));
        } else if (Float.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((float[])primitiveArray));
        } else if (Double.TYPE.equals(componentType)) {
            stringBuilder.append(Arrays.toString((double[])primitiveArray));
        }
    }
}

