/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.java.junit.dataprovider;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.junit.runner.Description;
import org.junit.runner.manipulation.Filter;

public class DataProviderFilter
extends Filter {
    static final Pattern DESCRIPTION_PATTERN = Pattern.compile("([^\\[\\] ]+)(\\[(\\d+):.*\\])?\\((.+)\\)$");
    private static final int GROUP_METHOD_NAME = 1;
    private static final int GROUP_METHOD_PARAMS = 2;
    private static final int GROUP_METHOD_IDX = 3;
    private static final int GROUP_CLASS = 4;
    final Filter filter;

    public DataProviderFilter(Filter filter) {
        if (filter == null) {
            throw new NullPointerException("supplied filter must not be null");
        }
        this.filter = filter;
    }

    public boolean shouldRun(Description description) {
        Matcher filterDescriptionMatcher = DESCRIPTION_PATTERN.matcher(this.filter.describe());
        if (!filterDescriptionMatcher.find()) {
            return this.filter.shouldRun(description);
        }
        if (description.isTest()) {
            Matcher descriptionMatcher = DESCRIPTION_PATTERN.matcher(description.getDisplayName());
            if (!descriptionMatcher.matches()) {
                return this.filter.shouldRun(description);
            }
            if (!filterDescriptionMatcher.group(1).equals(descriptionMatcher.group(1)) || !filterDescriptionMatcher.group(4).equals(descriptionMatcher.group(4))) {
                return false;
            }
            return filterDescriptionMatcher.group(2) == null || filterDescriptionMatcher.group(3).equals(descriptionMatcher.group(3));
        }
        for (Description each : description.getChildren()) {
            if (!this.shouldRun(each)) continue;
            return true;
        }
        return false;
    }

    public String describe() {
        return this.filter.describe();
    }
}

