/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.base.ArchUnitException;
import com.tngtech.archunit.base.Function;
import com.tngtech.archunit.thirdparty.com.google.common.collect.Collections2;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableList;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;

class ReflectionUtils {
    private ReflectionUtils() {
    }

    static Set<Class<?>> getAllSuperTypes(Class<?> type) {
        if (type == null) {
            return Collections.emptySet();
        }
        ImmutableSet.Builder result = ImmutableSet.builder().add(type).addAll(ReflectionUtils.getAllSuperTypes(type.getSuperclass()));
        for (Class<?> c : type.getInterfaces()) {
            result.addAll(ReflectionUtils.getAllSuperTypes(c));
        }
        return result.build();
    }

    static Collection<Field> getAllFields(Class<?> owner, Predicate<? super Field> predicate) {
        return Collections2.filter(ReflectionUtils.getAll(owner, new Collector<Field>(){

            @Override
            protected Collection<? extends Field> extractFrom(Class<?> type) {
                return ImmutableList.copyOf((Object[])type.getDeclaredFields());
            }
        }), ReflectionUtils.toGuava(predicate));
    }

    static Collection<Method> getAllMethods(Class<?> owner, Predicate<? super Method> predicate) {
        return Collections2.filter(ReflectionUtils.getAll(owner, new Collector<Method>(){

            @Override
            protected Collection<? extends Method> extractFrom(Class<?> type) {
                return ImmutableList.copyOf((Object[])type.getDeclaredMethods());
            }
        }), ReflectionUtils.toGuava(predicate));
    }

    private static <T> List<T> getAll(Class<?> type, Collector<T> collector) {
        for (Class<?> t : ReflectionUtils.getAllSuperTypes(type)) {
            collector.collectFrom(t);
        }
        return ((Collector)collector).collected;
    }

    static <T> T newInstanceOf(Class<T> type) {
        try {
            Constructor<T> constructor = type.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ArchUnitException.ReflectionException((Throwable)e);
        }
    }

    private static <T> T getValue(Field field, Object owner) {
        try {
            field.setAccessible(true);
            return (T)field.get(owner);
        }
        catch (IllegalAccessException e) {
            throw new ArchUnitException.ReflectionException((Throwable)e);
        }
    }

    static <T> T getValueOrThrowException(Field field, Class<?> fieldOwner, Function<Throwable, ? extends RuntimeException> exceptionConverter) {
        try {
            if (Modifier.isStatic(field.getModifiers())) {
                return ReflectionUtils.getValue(field, null);
            }
            return ReflectionUtils.getValue(field, ReflectionUtils.newInstanceOf(fieldOwner));
        }
        catch (ArchUnitException.ReflectionException e) {
            throw (RuntimeException)exceptionConverter.apply((Object)e.getCause());
        }
    }

    static <T> T invokeMethod(Method method, Class<?> methodOwner, Object ... args) {
        if (Modifier.isStatic(method.getModifiers())) {
            return ReflectionUtils.invoke(null, method, args);
        }
        return ReflectionUtils.invoke(ReflectionUtils.newInstanceOf(methodOwner), method, args);
    }

    private static <T> T invoke(Object owner, Method method, Object ... args) {
        method.setAccessible(true);
        try {
            return (T)method.invoke(owner, args);
        }
        catch (IllegalAccessException e) {
            throw new ArchUnitException.ReflectionException((Throwable)e);
        }
        catch (InvocationTargetException e) {
            ReflectionUtils.rethrowUnchecked(e.getTargetException());
            return null;
        }
    }

    private static <T extends Throwable> void rethrowUnchecked(Throwable throwable) throws T {
        throw throwable;
    }

    static Predicate<AnnotatedElement> withAnnotation(final Class<? extends Annotation> annotationType) {
        return new Predicate<AnnotatedElement>(){

            @Override
            public boolean apply(AnnotatedElement input) {
                return input.getAnnotation(annotationType) != null;
            }
        };
    }

    private static <T> com.tngtech.archunit.thirdparty.com.google.common.base.Predicate<T> toGuava(final Predicate<T> predicate) {
        return new com.tngtech.archunit.thirdparty.com.google.common.base.Predicate<T>(){

            public boolean apply(T input) {
                return predicate.apply(input);
            }
        };
    }

    static interface Predicate<T> {
        public boolean apply(T var1);
    }

    private static abstract class Collector<T> {
        private final List<T> collected = new ArrayList<T>();

        private Collector() {
        }

        void collectFrom(Class<?> type) {
            this.collected.addAll(this.extractFrom(type));
        }

        protected abstract Collection<? extends T> extractFrom(Class<?> var1);
    }
}

