/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit.internal;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.junit.internal.ArchTestExecution;
import com.tngtech.archunit.junit.internal.ArchTestInitializationException;
import com.tngtech.archunit.junit.internal.ReflectionUtils;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.junit.runner.Description;

class ArchTestMethodExecution
extends ArchTestExecution {
    private final Method testMethod;

    ArchTestMethodExecution(List<Class<?>> testClassPath, Class<?> ruleDeclaringClass, Method testMethod, boolean ignore) {
        super(testClassPath, ruleDeclaringClass, ignore);
        this.testMethod = testMethod;
    }

    @Override
    ArchTestExecution.Result evaluateOn(JavaClasses classes) {
        try {
            this.executeTestMethod(classes);
            return new ArchTestExecution.PositiveResult();
        }
        catch (Throwable failure) {
            return new ArchTestExecution.NegativeResult(this.describeSelf(), failure);
        }
    }

    private void executeTestMethod(JavaClasses classes) {
        ArchTestInitializationException.check(Arrays.equals(this.testMethod.getParameterTypes(), new Class[]{JavaClasses.class}), "Methods annotated with @%s must have exactly one parameter of type %s", ArchTest.class.getSimpleName(), JavaClasses.class.getSimpleName());
        ReflectionUtils.invokeMethod(this.testMethod, this.ruleDeclaringClass, classes);
    }

    @Override
    Description describeSelf() {
        return this.createDescription(this.testMethod);
    }

    @Override
    String getName() {
        return this.testMethod.getName();
    }
}

