/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.junit.ArchTestExecution;
import com.tngtech.archunit.junit.ArchTestInitializationException;
import com.tngtech.archunit.lang.ArchRule;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import org.junit.runner.Description;

class ArchRuleExecution
extends ArchTestExecution {
    private final Field ruleField;

    ArchRuleExecution(Class<?> testClass, Field ruleField, boolean ignore) {
        super(testClass, ignore);
        ArchTestInitializationException.check(ArchRule.class.isAssignableFrom(ruleField.getType()), "Rule field %s.%s to check must be of type %s", testClass.getSimpleName(), ruleField.getName(), ArchRule.class.getSimpleName());
        this.ruleField = ruleField;
    }

    @Override
    ArchTestExecution.Result evaluateOn(JavaClasses classes) {
        ArchRule rule = (ArchRule)ArchRuleExecution.getValue(this.ruleField, this.testClass);
        try {
            rule.check(classes);
        }
        catch (AssertionError | Exception e) {
            return new ArchTestExecution.NegativeResult(this.describeSelf(), (Throwable)e);
        }
        return new ArchTestExecution.PositiveResult();
    }

    @Override
    Description describeSelf() {
        return Description.createTestDescription((Class)this.testClass, (String)this.ruleField.getName(), (Annotation[])this.ruleField.getAnnotations());
    }

    @Override
    String getName() {
        return this.ruleField.getName();
    }
}

