/*
 * Decompiled with CFR 0.152.
 */
package com.timshadel.simplesecrets;

import com.timshadel.simplesecrets.Utilities;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.msgpack.MessagePack;
import org.msgpack.template.Template;

public class Primitives {
    private static final String CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    private static final String KEY_ALGORITHM = "AES";
    private static final String DIGEST_ALGORITHM = "SHA-256";
    private static final String HMAC_ALGORITHM = "HmacSHA256";

    public static byte[] nonce() {
        byte[] bytes = new byte[16];
        new SecureRandom().nextBytes(bytes);
        return bytes;
    }

    public static byte[] derive_sender_hmac(byte[] master_key) throws GeneralSecurityException {
        return Primitives.derive(master_key, "simple-crypto/sender-hmac-key");
    }

    public static byte[] derive_sender_key(byte[] master_key) throws GeneralSecurityException {
        return Primitives.derive(master_key, "simple-crypto/sender-cipher-key");
    }

    public static byte[] derive_receiver_hmac(byte[] master_key) throws GeneralSecurityException {
        return Primitives.derive(master_key, "simple-crypto/receiver-hmac-key");
    }

    public static byte[] derive_receiver_key(byte[] master_key) throws GeneralSecurityException {
        return Primitives.derive(master_key, "simple-crypto/receiver-cipher-key");
    }

    public static byte[] encrypt(byte[] binary, byte[] master_key) throws GeneralSecurityException {
        Utilities.assertBinary(binary);
        Utilities.assertBinarySize(master_key, 32);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        SecretKeySpec keySpec = new SecretKeySpec(master_key, KEY_ALGORITHM);
        cipher.init(1, keySpec);
        byte[] iv_bytes = cipher.getIV();
        byte[] binary_bytes = cipher.update(binary);
        byte[] final_bytes = cipher.doFinal();
        byte[] encrypted = Utilities.joinByteArrays(iv_bytes, binary_bytes, final_bytes);
        return encrypted;
    }

    public static byte[] decrypt(byte[] binary, byte[] master_key, byte[] iv) throws GeneralSecurityException {
        Utilities.assertBinary(binary);
        Utilities.assertBinarySize(master_key, 32);
        Utilities.assertBinarySize(iv, 16);
        Cipher cipher = Cipher.getInstance(CIPHER_ALGORITHM);
        SecretKeySpec keySpec = new SecretKeySpec(master_key, KEY_ALGORITHM);
        IvParameterSpec ivSpec = new IvParameterSpec(iv, 0, cipher.getBlockSize());
        cipher.init(2, (Key)keySpec, ivSpec);
        byte[] binary_bytes = cipher.update(binary);
        byte[] final_bytes = cipher.doFinal();
        byte[] decrypted = Utilities.joinByteArrays(binary_bytes, final_bytes);
        return decrypted;
    }

    public static byte[] identify(byte[] binary) throws GeneralSecurityException {
        Utilities.assertBinary(binary);
        MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        digest.update(BigInteger.valueOf(binary.length).toByteArray());
        digest.update(binary);
        byte[] hash = digest.digest();
        return Arrays.copyOfRange(hash, 0, 6);
    }

    public static byte[] mac(byte[] binary, byte[] hmac_key) throws GeneralSecurityException {
        Utilities.assertBinary(binary);
        Utilities.assertBinarySize(hmac_key, 32);
        SecretKeySpec keySpec = new SecretKeySpec(hmac_key, HMAC_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_ALGORITHM);
        mac.init(keySpec);
        return mac.doFinal(binary);
    }

    public static boolean compare(byte[] a, byte[] b) {
        Utilities.assertBinary(a);
        Utilities.assertBinary(b);
        if (a.length != b.length) {
            return false;
        }
        int same = 0;
        for (int i = 0; i < a.length; ++i) {
            same += a[i] ^ b[i];
        }
        return same == 0;
    }

    public static byte[] binify(String base64) {
        if (base64 == null || !Base64.isBase64((String)base64)) {
            throw new IllegalArgumentException("Base64 string required.");
        }
        String _base64 = base64.length() % 4 != 0 ? StringUtils.rightPad((String)base64, (int)(base64.length() + (4 - base64.length() % 4)), (char)'=') : base64;
        return Base64.decodeBase64((String)_base64);
    }

    public static String stringify(byte[] binary) {
        Utilities.assertBinary(binary);
        return Base64.encodeBase64URLSafeString((byte[])binary);
    }

    public static byte[] serialize(Object object) throws IOException {
        return new MessagePack().write(object);
    }

    public static <T> T deserialize(byte[] binary, Class<T> klass) throws IOException {
        Utilities.assertBinary(binary);
        if (klass == null) {
            throw new IllegalArgumentException("Class type required for deserialization.");
        }
        return (T)new MessagePack().read(binary, klass);
    }

    public static <T> T deserialize(byte[] binary, Template<T> template) throws IOException {
        Utilities.assertBinary(binary);
        if (template == null) {
            throw new IllegalArgumentException("Template type required for deserialization.");
        }
        return (T)new MessagePack().read(binary, template);
    }

    public static void zero(byte[] ... binaries) {
        if (binaries == null) {
            return;
        }
        for (byte[] binary : binaries) {
            if (binary == null) continue;
            for (int i = 0; i < binary.length; ++i) {
                binary[i] = 0;
            }
        }
    }

    private static byte[] derive(byte[] master_key, String role) throws GeneralSecurityException {
        Utilities.assertBinarySize(master_key, 32);
        MessageDigest digest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        digest.update(master_key);
        digest.update(role.getBytes());
        return digest.digest();
    }
}

