/*
 * Decompiled with CFR 0.152.
 */
package com.tickaroo.tikxml.processor;

import com.google.auto.service.AutoService;
import com.tickaroo.tikxml.annotation.Xml;
import com.tickaroo.tikxml.processor.ProcessingException;
import com.tickaroo.tikxml.processor.field.AnnotatedClassImpl;
import com.tickaroo.tikxml.processor.generator.TypeAdapterCodeGenerator;
import com.tickaroo.tikxml.processor.scanning.AnnotationDetector;
import com.tickaroo.tikxml.processor.scanning.AnnotationScanner;
import com.tickaroo.tikxml.processor.scanning.DefaultAnnotationDetector;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;

@AutoService(value=Processor.class)
public class XmlProcessor
extends AbstractProcessor {
    private static final String OPTION_TYPE_CONVERTER_FOR_PRIMITIVES = "primitiveTypeConverters";
    private Messager messager;
    private Filer filer;
    private Elements elementUtils;
    private Types typeUtils;
    private AnnotationDetector annotationDetector;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.messager = processingEnv.getMessager();
        this.filer = processingEnv.getFiler();
        this.elementUtils = processingEnv.getElementUtils();
        this.typeUtils = processingEnv.getTypeUtils();
        this.annotationDetector = new DefaultAnnotationDetector(this.elementUtils, this.typeUtils);
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add(Xml.class.getCanonicalName());
        return types;
    }

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> options = new HashSet<String>();
        options.add(OPTION_TYPE_CONVERTER_FOR_PRIMITIVES);
        return options;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            String primitiveTypeConverterOptions = this.processingEnv.getOptions().get(OPTION_TYPE_CONVERTER_FOR_PRIMITIVES);
            Set<String> primitiveTypeConverters = this.readPrimitiveTypeConverterOptions(primitiveTypeConverterOptions);
            AnnotationScanner scanner = new AnnotationScanner(this.elementUtils, this.typeUtils, this.annotationDetector);
            Set<? extends Element> elementsAnnotatedWith = roundEnv.getElementsAnnotatedWith(Xml.class);
            for (Element element : elementsAnnotatedWith) {
                if (element.getKind() == ElementKind.CLASS && element.getModifiers().contains((Object)Modifier.ABSTRACT)) continue;
                AnnotatedClassImpl clazz = new AnnotatedClassImpl(element);
                scanner.scan(clazz);
                TypeAdapterCodeGenerator generator = new TypeAdapterCodeGenerator(this.filer, this.elementUtils, this.typeUtils, primitiveTypeConverters);
                generator.generateCode(clazz);
            }
        }
        catch (ProcessingException e) {
            this.printError(e);
        }
        return false;
    }

    Set<String> readPrimitiveTypeConverterOptions(String optionsAsString) {
        HashSet<String> primitiveTypeConverters = new HashSet<String>();
        if (optionsAsString != null && optionsAsString.length() > 0) {
            String[] options;
            for (String o : options = optionsAsString.split(",")) {
                primitiveTypeConverters.add(o.trim());
            }
        }
        return primitiveTypeConverters;
    }

    private void printError(ProcessingException exception) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, exception.getMessage(), exception.getElement());
    }
}

