package com.thetransactioncompany.util;


import java.util.Properties;


/**
 * Property filtering utilities.
 *
 * @author Vladimir Dzhuvinov
 */
public class PropertyFilter {
	


	/**
	 * Filters properties with the specified name prefix.
	 *
	 * @param prefix The property name prefix to filter matching
	 *               properties. Must not be {@code null}.
	 * @param props  The properties to filter, {@code null}
	 *
	 * @return The filtered properties, empty if no matches were found or
	 *         the original properties are empty or {@code null}.
	 */
	public static Properties filterWithPrefix(final String prefix, final Properties props) {

		Properties filteredProps = new Properties();

		if (props == null || props.isEmpty()) {
			return filteredProps;
		}

		for (String key: props.stringPropertyNames()) {

			if (key.startsWith(prefix)) {
				filteredProps.put(key, props.getProperty(key));
			}
		}

		return filteredProps;
	}
}
