/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.NamespaceInFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.compiler.util.scan.InclusionScanException;
import org.codehaus.plexus.compiler.util.scan.SimpleSourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.SourceInclusionScanner;
import org.codehaus.plexus.compiler.util.scan.StaleSourceScanner;
import org.codehaus.plexus.compiler.util.scan.mapping.SourceMapping;
import org.codehaus.plexus.compiler.util.scan.mapping.SuffixMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NamespaceDiscovery {
    private static final String TEMPORARY_FILES_REGEXP = "^(\\.|#).*";
    private final Pattern nsPattern = Pattern.compile("^\\s*\\(ns(\\s.*|$)");
    private Log log;
    private boolean compileDeclaredNamespaceOnly;
    private File targetPath;
    private boolean includeStale;

    public NamespaceDiscovery(Log log, File targetPath, boolean compileDeclaredNamespaceOnly) {
        this(log, targetPath, compileDeclaredNamespaceOnly, true);
    }

    public NamespaceDiscovery(Log log, File targetPath, boolean compileDeclaredNamespaceOnly, boolean includeStale) {
        this.log = log;
        this.targetPath = targetPath;
        this.compileDeclaredNamespaceOnly = compileDeclaredNamespaceOnly;
        this.includeStale = includeStale;
    }

    public NamespaceInFile[] discoverNamespacesIn(String[] namespaceFilterRegexs, File ... paths) throws MojoExecutionException {
        if (namespaceFilterRegexs == null || namespaceFilterRegexs.length == 0) {
            namespaceFilterRegexs = new String[]{".*"};
        }
        HashSet<NamespaceInFile> namespaces = new HashSet<NamespaceInFile>();
        for (NamespaceInFile namespace : this.discoverNamespacesInPath(paths)) {
            boolean toAdd = !this.compileDeclaredNamespaceOnly;
            for (String regex : namespaceFilterRegexs) {
                if (regex.startsWith("!")) {
                    if (!Pattern.compile("^" + regex.substring(1)).matcher(namespace.getName()).matches()) continue;
                    toAdd = false;
                    break;
                }
                if (!Pattern.compile("^" + regex).matcher(namespace.getName()).matches()) continue;
                toAdd = true;
            }
            if (toAdd) {
                namespaces.add(namespace);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug((CharSequence)("Filtered namespace " + namespace.getName() + " from clojure build."));
        }
        return namespaces.toArray(new NamespaceInFile[0]);
    }

    public List<NamespaceInFile> discoverNamespacesInPath(File ... paths) throws MojoExecutionException {
        ArrayList<NamespaceInFile> namespaces = new ArrayList<NamespaceInFile>();
        for (File path : paths) {
            namespaces.addAll(this.discoverNamespacesIn(path));
        }
        return namespaces;
    }

    public List<NamespaceInFile> discoverNamespacesIn(File basePath) throws MojoExecutionException {
        Set sourceFiles;
        if (!basePath.exists()) {
            return Collections.EMPTY_LIST;
        }
        SourceInclusionScanner scanner = this.getSourceInclusionScanner(this.includeStale);
        SuffixMapping mapping = new SuffixMapping(".clj", new HashSet<String>(Arrays.asList(".clj", "__init.class")));
        scanner.addSourceMapping((SourceMapping)mapping);
        try {
            sourceFiles = scanner.getIncludedSources(basePath, this.targetPath);
        }
        catch (InclusionScanException e) {
            throw new MojoExecutionException("Error scanning source path: '" + basePath.getPath() + "' " + "for  files to recompile.", (Exception)((Object)e));
        }
        ArrayList<NamespaceInFile> namespaces = new ArrayList<NamespaceInFile>();
        for (File file : sourceFiles) {
            if (file.getName().matches(TEMPORARY_FILES_REGEXP)) continue;
            namespaces.addAll(this.findNamespaceInFile(basePath, file));
        }
        return namespaces;
    }

    protected SourceInclusionScanner getSourceInclusionScanner(boolean includeStale) {
        return includeStale ? new SimpleSourceInclusionScanner(Collections.singleton("**/*"), Collections.EMPTY_SET) : new StaleSourceScanner(1024L);
    }

    private List<NamespaceInFile> findNamespaceInFile(File path, File file) throws MojoExecutionException {
        ArrayList<NamespaceInFile> namespaces = new ArrayList<NamespaceInFile>();
        Scanner scanner = null;
        try {
            scanner = new Scanner(file);
            scanner.useDelimiter("\n");
            while (scanner.hasNext()) {
                String line = scanner.next();
                Matcher matcher = this.nsPattern.matcher(line);
                if (!matcher.find()) continue;
                String ns = file.getPath();
                ns = ns.substring(path.getPath().length() + 1, ns.length() - ".clj".length());
                ns = ns.replace(File.separatorChar, '.');
                ns = ns.replace('_', '-');
                this.log.debug((CharSequence)("Found namespace " + ns + " in file " + file.getPath()));
                namespaces.add(new NamespaceInFile(ns, file));
            }
        }
        catch (FileNotFoundException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        return namespaces;
    }
}

