/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractise.clojure;

import com.theoryinpractise.clojure.AbstractClojureCompilerMojo;
import com.theoryinpractise.clojure.NamespaceDiscovery;
import com.theoryinpractise.clojure.NamespaceInFile;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;

public class ClojureGenDocMojo
extends AbstractClojureCompilerMojo {
    private boolean generateTestDocumentation;

    public void execute() throws MojoExecutionException {
        NamespaceInFile[] allNamespaces;
        File docsDir;
        File genDocClj;
        try {
            genDocClj = File.createTempFile("generate-docs", ".clj");
            if (!this.outputDirectory.getParentFile().exists()) {
                this.outputDirectory.getParentFile().mkdir();
            }
            docsDir = new File(this.outputDirectory.getParentFile(), "clojure");
            this.getLog().debug((CharSequence)("Creating documentation directory " + docsDir.getPath()));
            docsDir.mkdir();
            System.out.println(docsDir.getPath() + " exists " + docsDir.exists());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(use 'clojure.contrib.gen-html-docs)\n");
        sb.append("(generate-documentation-to-file \n");
        int count = 0;
        sb.append("  \"").append(docsDir.getPath().replace('\\', '/')).append("/index.html\"\n");
        sb.append("  [");
        for (NamespaceInFile namespace : allNamespaces = new NamespaceDiscovery(this.getLog(), this.outputDirectory, this.compileDeclaredNamespaceOnly).discoverNamespacesIn(this.namespaces, this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.COMPILE, AbstractClojureCompilerMojo.SourceDirectory.TEST))) {
            sb.append("'").append(namespace.getName());
            if (count++ >= allNamespaces.length - 1) continue;
            sb.append("\n   ");
        }
        sb.append("])\n");
        try {
            PrintWriter pw = new PrintWriter(genDocClj);
            pw.print(sb.toString());
            pw.close();
            this.getLog().info((CharSequence)("Generating docs to " + docsDir.getCanonicalPath() + " with " + genDocClj.getPath()));
            this.getLog().debug((CharSequence)sb.toString());
        }
        catch (IOException e) {
            throw new MojoExecutionException(e.getMessage());
        }
        this.callClojureWith(this.getSourceDirectories(AbstractClojureCompilerMojo.SourceDirectory.COMPILE, AbstractClojureCompilerMojo.SourceDirectory.TEST), this.outputDirectory, (List<String>)this.testClasspathElements, "clojure.main", new String[]{genDocClj.getPath()});
    }
}

