/*
 * Decompiled with CFR 0.152.
 */
package com.thelastcheck.commons.buffer;

import com.thelastcheck.commons.buffer.BufferCapacityReachedException;
import com.thelastcheck.commons.buffer.ByteArray;
import java.io.IOException;
import java.io.Writer;
import org.slf4j.LoggerFactory;

public class ByteArrayWriter
extends Writer {
    private static final String CVS_ID = "$Date: 2010/11/15 17:42:05 $ $Revision: 1.3 $";
    private static int INITIAL_SIZE;
    private ByteArray buffer;
    private int position;
    private int limit;
    private boolean canResize;

    public ByteArrayWriter() {
        this(INITIAL_SIZE);
    }

    public ByteArrayWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative buffer size");
        }
        this.buffer = new ByteArray(initialSize);
        this.position = 0;
        this.limit = initialSize;
        this.canResize = true;
    }

    public ByteArrayWriter(ByteArray buffer) {
        this.buffer = buffer;
        this.position = 0;
        this.limit = buffer.getLength();
        this.canResize = false;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void write(char[] cbuf, int off, int len) throws IOException {
        this.ensureCapacity(this.position + len);
        if (off < 0 || off > cbuf.length || len < 0 || off + len > cbuf.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        this.buffer.write(cbuf, off, len, this.position);
        this.position += len;
    }

    public ByteArray getBuffer() {
        if (this.position == this.limit) {
            return this.buffer;
        }
        return this.buffer.slice(0, this.position);
    }

    public int getTotalBytesWritten() {
        return this.position;
    }

    @Override
    public void write(int c) {
        this.ensureCapacity(this.position + 1);
        this.buffer.write((char)c, this.position++);
    }

    @Override
    public void write(String str) {
        this.ensureCapacity(this.position + str.length());
        this.buffer.write(str, this.position);
        this.position += str.length();
    }

    @Override
    public void write(String str, int off, int len) {
        this.ensureCapacity(this.position + len);
        this.buffer.write(str.substring(off, off + len), this.position);
        this.position += len;
    }

    private void ensureCapacity(int minimumCapacity) {
        if (minimumCapacity > this.limit) {
            if (this.canResize) {
                this.expandCapacity(minimumCapacity);
            } else {
                throw new BufferCapacityReachedException();
            }
        }
    }

    private void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.limit + 1) * 2;
        if (newCapacity < 0) {
            newCapacity = Integer.MAX_VALUE;
        } else if (minimumCapacity > newCapacity) {
            newCapacity = minimumCapacity;
        }
        ByteArray newBuffer = new ByteArray(newCapacity, this.buffer.getEncoding(), this.buffer.getOrder());
        newBuffer.write(this.buffer.getArray().value, 0);
        this.buffer = newBuffer;
        this.limit = newCapacity;
    }

    static {
        String className = ByteArrayWriter.class.getName();
        LoggerFactory.getLogger((String)"version").info(className + " | " + CVS_ID);
        INITIAL_SIZE = 100;
    }
}

