/*
 * Decompiled with CFR 0.152.
 */
package com.textmagic.sdk.resource.instance;

import com.textmagic.sdk.RequestMethod;
import com.textmagic.sdk.RestClient;
import com.textmagic.sdk.RestException;
import com.textmagic.sdk.RestResponse;
import com.textmagic.sdk.resource.InstanceResource;
import com.textmagic.sdk.resource.instance.TMContact;
import com.textmagic.sdk.resource.instance.TMListContactList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class TMList
extends InstanceResource<RestClient> {
    public TMList(RestClient client) {
        super(client);
        this.requestFields = new HashSet<String>(Arrays.asList("name", "shared"));
    }

    public TMList(RestClient client, Map<String, Object> properties) {
        super(client, properties);
        this.requestFields = new HashSet<String>(Arrays.asList("name", "shared"));
    }

    @Override
    protected String getResourcePath() {
        return "lists";
    }

    public Integer getId() {
        return (Integer)this.getProperty("id");
    }

    public String getName() {
        return (String)this.getProperty("name");
    }

    public void setName(String name) {
        this.setProperty("name", name);
    }

    public String getDescription() {
        return (String)this.getProperty("description");
    }

    public Integer getMembersCount() {
        return (Integer)this.getProperty("membersCount");
    }

    public Boolean getShared() {
        return (Boolean)this.getProperty("shared");
    }

    public void setShared(Boolean shared) {
        this.setProperty("shared", shared);
    }

    public Iterator<TMContact> getContactsIterator() {
        if (this.properties.size() > 0) {
            TMListContactList lcl = new TMListContactList((RestClient)this.getClient(), (Integer)this.getProperty("id"));
            return lcl.iterator();
        }
        throw new UnsupportedOperationException("This operation is unsupported for non existent list");
    }

    public boolean addContactsToList(List<Integer> contacts) throws RestException {
        if (this.properties.size() > 0) {
            this.clearParameters();
            ArrayList<String> param = new ArrayList<String>();
            for (Integer id : contacts) {
                param.add(Integer.toString(id));
            }
            this.parameters.put("contacts", StringUtils.join(param, (String)","));
            RestResponse response = ((RestClient)this.getClient()).request(this.getResourcePath() + '/' + this.getProperty("id") + "/contacts", RequestMethod.PUT, this.parameters);
            this.clearParameters();
            return !response.isError();
        }
        throw new UnsupportedOperationException("This operation is unsupported for non existent list");
    }

    public boolean removeContactsFromList(List<Integer> contacts) throws RestException {
        if (this.properties.size() > 0) {
            this.clearParameters();
            ArrayList<String> param = new ArrayList<String>();
            for (Integer id : contacts) {
                param.add(Integer.toString(id));
            }
            this.parameters.put("contacts", StringUtils.join(param, (String)","));
            RestResponse response = ((RestClient)this.getClient()).request(this.getResourcePath() + '/' + this.getProperty("id") + "/contacts", RequestMethod.DELETE, this.parameters);
            this.clearParameters();
            return !response.isError();
        }
        throw new UnsupportedOperationException("This operation is unsupported for non existent list");
    }
}

