/*
 * Decompiled with CFR 0.152.
 */
package com.textmagic.sdk.resource;

import com.textmagic.sdk.ClientException;
import com.textmagic.sdk.RequestMethod;
import com.textmagic.sdk.RestClient;
import com.textmagic.sdk.RestException;
import com.textmagic.sdk.RestResponse;
import com.textmagic.sdk.resource.Resource;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public abstract class ListResource<T extends Resource, C extends RestClient>
extends Resource<C>
implements Iterable<T> {
    protected List<T> pageData;
    protected Integer page = 1;
    protected Integer limit = 10;
    protected Integer pageCount = 0;

    public ListResource(C client) {
        this(client, new HashMap<String, String>());
    }

    public ListResource(C client, Map<String, String> parameters) {
        super(client);
        this.parameters = parameters;
    }

    @Override
    public Iterator<T> iterator() {
        try {
            return new ListIterator(this.getPageData().iterator());
        }
        catch (RestException e) {
            throw new ClientException(e);
        }
    }

    protected boolean hasNextPage() {
        return this.page < this.pageCount;
    }

    protected void getListContent() throws RestException, ClientException {
        this.parameters.put("page", Integer.toString(this.page));
        this.parameters.put("limit", Integer.toString(this.limit));
        StringBuilder sb = new StringBuilder();
        sb.append(this.getResourcePath());
        if (this.parameters.size() > 2) {
            sb.append("/search");
        }
        RestResponse response = ((RestClient)this.getClient()).request(sb.toString(), RequestMethod.GET, this.parameters);
        Map<String, Object> data = response.toMap();
        this.page = this.getIntValue(data.get("page"));
        this.limit = this.getIntValue(data.get("limit"));
        this.pageCount = this.getIntValue(data.get("pageCount"));
        this.pageData = new ArrayList<T>();
        List resources = (List)data.get("resources");
        for (Object resource : resources) {
            if (!(resource instanceof Map)) continue;
            T instance = this.makeListItem(this.getClient(), (Map)resource);
            this.pageData.add(instance);
        }
    }

    protected void fetchNextPage() throws RestException {
        Integer n = this.page;
        Integer n2 = this.page = Integer.valueOf(this.page + 1);
        this.getListContent();
    }

    public List<T> getPageData() throws RestException {
        if (this.pageData == null) {
            this.getListContent();
        }
        return Collections.unmodifiableList(this.pageData);
    }

    protected abstract T makeListItem(C var1, Map<String, Object> var2);

    private class ListIterator
    implements Iterator<T> {
        private Iterator<T> itr;

        public ListIterator(Iterator<T> itr) {
            this.itr = itr;
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasNext() || ListResource.this.hasNextPage();
        }

        @Override
        public T next() {
            if (this.itr.hasNext()) {
                return (Resource)this.itr.next();
            }
            try {
                ListResource.this.fetchNextPage();
            }
            catch (RestException e) {
                throw new ClientException(e);
            }
            this.itr = ListResource.this.pageData.iterator();
            return (Resource)this.itr.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

