/*
 * Decompiled with CFR 0.152.
 */
package com.textmagic.sdk.resource;

import com.textmagic.sdk.ClientException;
import com.textmagic.sdk.RequestMethod;
import com.textmagic.sdk.RestClient;
import com.textmagic.sdk.RestException;
import com.textmagic.sdk.RestResponse;
import com.textmagic.sdk.resource.Resource;
import java.text.ParseException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;

public abstract class InstanceResource<C extends RestClient>
extends Resource<C> {
    protected Map<String, Object> properties;

    public InstanceResource(C client) {
        super(client);
        this.clearProperties();
        this.clearParameters();
    }

    public InstanceResource(C client, Map<String, Object> properties) {
        super(client);
        this.clearParameters();
        this.properties = properties != null && properties.size() > 0 ? new HashMap<String, Object>(properties) : new HashMap<String, Object>();
    }

    protected void clearProperties() {
        this.properties = new HashMap<String, Object>();
    }

    protected void clearParameters() {
        this.parameters = new HashMap();
    }

    protected Object getProperty(String name) {
        return this.properties.get(name);
    }

    protected void setProperty(String name, Object value) {
        this.properties.put(name, value);
    }

    protected Map<String, Object> getProperties() {
        return Collections.unmodifiableMap(this.properties);
    }

    protected Date getDate(String name) {
        String property = (String)this.getProperty(name);
        if (property == null) {
            return null;
        }
        try {
            return DateUtils.parseDateStrictly((String)property, (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ssZ"});
        }
        catch (ParseException e) {
            return null;
        }
    }

    protected void setDate(String name, Date value) {
        this.properties.put(name, DateFormatUtils.format((Date)value, (String)"yyyy-MM-dd'T'HH:mm:ssZ"));
    }

    public boolean get(Integer id) throws RestException, ClientException {
        if (this.properties.size() == 0) {
            RestResponse response = ((RestClient)this.getClient()).request(this.getResourcePath() + '/' + id, RequestMethod.GET);
            this.properties = new HashMap<String, Object>(response.toMap());
            return !response.isError();
        }
        throw new UnsupportedOperationException("This operation is unsupported for existent objects");
    }

    public boolean createOrUpdate() throws RestException, ClientException {
        String resourcePath = null;
        RequestMethod method = null;
        if (this.getProperty("id") == null) {
            method = RequestMethod.POST;
            resourcePath = this.getResourcePath();
        } else {
            method = RequestMethod.PUT;
            resourcePath = this.getResourcePath() + '/' + this.getProperty("id");
        }
        RestResponse response = ((RestClient)this.getClient()).request(resourcePath, method, this.buildRequestParameters(this.properties));
        Map<String, Object> properties = response.toMap();
        Integer id = (Integer)properties.get("id");
        this.clearProperties();
        return this.get(id);
    }

    public boolean delete() throws RestException, ClientException {
        if (this.getProperty("id") == null) {
            throw new UnsupportedOperationException("This operation is unsupported for non existent objects");
        }
        RestResponse response = ((RestClient)this.getClient()).request(this.getResourcePath() + '/' + this.getProperty("id"), RequestMethod.DELETE);
        this.clearProperties();
        return !response.isError();
    }

    public boolean equals(Object obj) {
        if (obj instanceof InstanceResource) {
            InstanceResource other = (InstanceResource)obj;
            return this.getProperties().equals(other.getProperties());
        }
        return super.equals(obj);
    }
}

