/*
 * Decompiled with CFR 0.152.
 */
package com.testvagrant.optimuscloud.utils;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;
import org.openqa.selenium.remote.DesiredCapabilities;

public class CapabilitiesBuilder {
    private DesiredCapabilities capabilities = new DesiredCapabilities();
    private JSONObject testFeedJSON;

    public CapabilitiesBuilder(JSONObject testFeedJSON) {
        this.testFeedJSON = testFeedJSON;
        JSONObject appiumServerCapabilities = (JSONObject)((JSONObject)testFeedJSON.get("optimusDesiredCapabilities")).get("appiumServerCapabilities");
        if (!this.isNativeApp()) {
            this.buildWebAppCapabilities(appiumServerCapabilities);
            return;
        }
        String appPath = CapabilitiesBuilder.getAppPath((String)testFeedJSON.get("appDir"), (String)appiumServerCapabilities.get("app"));
        this.capabilities.setCapability("app", appPath);
        this.initializeCapabilities();
    }

    private void buildWebAppCapabilities(JSONObject appiumServerCapabilities) {
        if (this.isBrowserAppProvided(appiumServerCapabilities)) {
            String appPath = CapabilitiesBuilder.getAppPath((String)appiumServerCapabilities.get("appDir"), (String)appiumServerCapabilities.get("app"));
            this.capabilities.setCapability("app", appPath);
        }
        this.initializeCapabilities();
    }

    private boolean isAndroid(JSONObject testFeedJSON) {
        String platformName = (String)testFeedJSON.get("platformName");
        return platformName.equalsIgnoreCase("Android");
    }

    private boolean isNativeApp() {
        Boolean nativeApp = this.testFeedJSON.getBoolean("nativeApp");
        return nativeApp;
    }

    private boolean isBrowserAppProvided(JSONObject testFeedJSON) {
        try {
            String string = testFeedJSON.getString("app");
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    private void initializeCapabilities() {
        JSONObject appiumServerCapabilities = (JSONObject)((JSONObject)this.testFeedJSON.get("optimusDesiredCapabilities")).get("appiumServerCapabilities");
        JSONObject platformSpecificCapabilities = null;
        if (appiumServerCapabilities.get("platformName").toString().equalsIgnoreCase("Android")) {
            platformSpecificCapabilities = (JSONObject)((JSONObject)this.testFeedJSON.get("optimusDesiredCapabilities")).get("androidOnlyCapabilities");
        } else if (appiumServerCapabilities.get("platformName").toString().equalsIgnoreCase("iOS")) {
            platformSpecificCapabilities = (JSONObject)((JSONObject)this.testFeedJSON.get("optimusDesiredCapabilities")).get("iOSOnlyCapabilities");
        }
        this.setDesiredCapabilities(appiumServerCapabilities, this.capabilities);
        this.setDesiredCapabilities(platformSpecificCapabilities, this.capabilities);
    }

    private void setDesiredCapabilities(JSONObject platformSpecificCapabilities, DesiredCapabilities desiredCapabilities) {
        Iterator keys = platformSpecificCapabilities.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            if (key.equalsIgnoreCase("app")) continue;
            Object value = platformSpecificCapabilities.get(key);
            if (value instanceof Boolean) {
                desiredCapabilities.setCapability(key, platformSpecificCapabilities.getBoolean(key));
                continue;
            }
            if (value instanceof String) {
                desiredCapabilities.setCapability(key, platformSpecificCapabilities.get(key));
                continue;
            }
            if (value instanceof Integer) {
                desiredCapabilities.setCapability(key, (Object)platformSpecificCapabilities.getInt(key));
                continue;
            }
            if (!(value instanceof JSONArray)) continue;
            desiredCapabilities.setCapability(key, (Object)platformSpecificCapabilities.getJSONArray(key));
        }
    }

    public DesiredCapabilities buildCapabilities() {
        return this.capabilities;
    }

    private static String getAppPath(String appLocation, String appName) {
        if (CapabilitiesBuilder.isUri(appName)) {
            return appName;
        }
        File appDir = new File(appLocation);
        return new File(appDir, appName).getAbsolutePath();
    }

    private static boolean isUri(String app) {
        try {
            URI uri = new URI(app);
            String host = uri.getHost();
            return host != null;
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

