package com.testvagrant.optimuscloud.local;

import com.testvagrant.optimuscloud.entities.MobileDriverDetails;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.MobileDriver;
import io.appium.java_client.android.AndroidDriver;
import io.appium.java_client.ios.IOSDriver;
import io.appium.java_client.service.local.AppiumDriverLocalService;
import io.appium.java_client.service.local.AppiumServiceBuilder;
import io.appium.java_client.service.local.flags.AndroidServerFlag;
import org.openqa.selenium.Platform;
import org.openqa.selenium.remote.DesiredCapabilities;

import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.URL;

public class OptimusLocalDriver {

    private MobileDriver mobileDriver;
    private AppiumDriverLocalService appiumService;
    public MobileDriverDetails createDriver(DesiredCapabilities desiredCapabilities) {
        appiumService = createAppiumService(desiredCapabilities);
        launchAppiumService(appiumService);
        mobileDriver = addDriver(appiumService.getUrl(), desiredCapabilities);
        return mapDriver(mobileDriver, desiredCapabilities);
    }

    private void launchAppiumService(AppiumDriverLocalService appiumService) {
        appiumService.start();
        while (!appiumService.isRunning()) {
            try {
                Thread.sleep(1000);
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    public void killDriver() {
        appiumService.stop();
    }

    private MobileDriverDetails mapDriver(MobileDriver mobileDriver, DesiredCapabilities desiredCapabilities) {
        MobileDriverDetails mobileDriverDetails = new MobileDriverDetails();
        mobileDriverDetails.setDesiredCapabilities(desiredCapabilities);
        mobileDriverDetails.setMobileDriver(mobileDriver);
        return mobileDriverDetails;
    }

    private AppiumDriverLocalService createAppiumService(DesiredCapabilities desiredCapabilities) {
        AppiumServiceBuilder serviceBuilder = new AppiumServiceBuilder()
                .usingAnyFreePort();
        if (desiredCapabilities.getPlatform().is(Platform.ANDROID)) {
            serviceBuilder.withArgument(AndroidServerFlag.BOOTSTRAP_PORT_NUMBER, String.valueOf(findRandomOpenPortOnAllLocalInterfaces()));
        } else {
            serviceBuilder.withArgument(WDAServerFlag.WDA_PORT, String.valueOf(findRandomOpenPortOnAllLocalInterfaces()));
        }

        return serviceBuilder.build();
    }

    private Integer findRandomOpenPortOnAllLocalInterfaces() {
        try (
                ServerSocket socket = new ServerSocket(0);
        ) {
            return socket.getLocalPort();

        } catch (Exception e) {
            e.printStackTrace();
        }
        throw new RuntimeException("Cannot find open port");
    }

    public MobileDriver addDriver(URL url, DesiredCapabilities capabilities) {

        try {
            return setUpDevice(url, capabilities);
        } catch (MalformedURLException e) {
            e.printStackTrace();
        }
        throw new RuntimeException("Driver could not be created for -- " + capabilities.getCapability("udid"));
    }

    private AppiumDriver setUpDevice(URL url, DesiredCapabilities capabilities) throws MalformedURLException {

        if (capabilities.getPlatform().is(Platform.ANDROID)) {
            return new AndroidDriver(url, capabilities);
        }
        return new IOSDriver(url, capabilities);
    }
}
