package com.testvagrant.optimuscloud.messaging;

import com.rabbitmq.client.*;

import java.io.IOException;
import java.util.concurrent.TimeoutException;

public class SessionQueueReader {

    public synchronized String  consumeMessage(String routingKey) throws IOException, TimeoutException {
        Channel channel = SessionConnection.getInstance().getChannel();
        synchronized (this) {
            try {
                GetResponse getResponse = channel.basicGet(routingKey, false);
                return new String(getResponse.getBody(),"UTF-8");
            } catch (Exception e) {
                return null;
            }
        }
    }

    public synchronized boolean queueHasAMessage(String queue_name) throws IOException, TimeoutException {
        Channel channel = SessionConnection.getInstance().getChannel();
        long messageCount = channel.messageCount(queue_name);
        return messageCount>0;
    }
}
