package com.testvagrant.optimuscloud.messaging;

import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ConnectionFactory;
import com.testvagrant.optimuscloud.configuration.OptimusCloudConfiguration;
import lombok.Getter;
import lombok.Setter;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.concurrent.TimeoutException;

public class SessionConnection {

    private static SessionConnection sessionConnection;
    private static Channel channel;
    private SessionConnection() throws TimeoutException, IOException {
        ConnectionFactory connectionFactory = new ConnectionFactory();
        try {
            URI url = new URI(OptimusCloudConfiguration.RABBIT_MQ_HOST);
            connectionFactory.setHost(url.getHost());
            connectionFactory.setPort(url.getPort());
            if(url.getUserInfo()!=null) {
                UserInfo userInfo = getUserInfo(url.getUserInfo());
                connectionFactory.setUsername(userInfo.getUsername());
                connectionFactory.setPassword(userInfo.getPassword());
            }
        } catch (URISyntaxException e) {
            connectionFactory.setHost("localhost");
        }

         Connection connection = connectionFactory.newConnection();
         channel = connection.createChannel();

    }

    public static SessionConnection getInstance() throws IOException, TimeoutException {
        if(sessionConnection==null) {
            sessionConnection =  new SessionConnection();
        }
        return sessionConnection;
    }

    public Channel getChannel() throws IOException {
        return channel;
    }

    private UserInfo getUserInfo(String userInfoStr) {
        UserInfo userInfo = new UserInfo();
        String[] userInfoDetails = userInfoStr.trim().split(":");
        userInfo.setUsername(userInfoDetails[0]);
        userInfo.setPassword(userInfoDetails[1]);
        return userInfo;
    }

    @Getter @Setter
    private static class UserInfo {
        private String username;
        private String password;
    }


}
