/*
 * Decompiled with CFR 0.152.
 */
package com.testvagrant.optimuscloud.clients;

import com.testvagrant.optimuscloud.configuration.OptimusCloudConfiguration;
import com.testvagrant.optimuscloud.entities.MandatoryCaps;
import com.testvagrant.optimuscloud.entities.SessionDetails;
import com.testvagrant.optimuscloud.entities.SessionReservationDetails;
import com.testvagrant.optimuscloud.entities.SessionState;
import io.restassured.RestAssured;
import io.restassured.response.Response;
import java.util.LinkedHashMap;

public class AkiraClient {
    private static final String HOST = OptimusCloudConfiguration.AKIRA_HOST;
    private static final String RESERVE_SESSION = HOST + "/reserveSession";
    private static final String UNRESERVE_SESSION = HOST + "/unReserveSession";
    private static final String SESSION_STATE = HOST + "/sessionState";
    private static final String SESSION_CURRENT_STATE = "/currentState";
    private static final String ENGAGE_SESSION = SESSION_STATE + "/engage";
    private static final String RELEASE_SESSION = SESSION_STATE + "/release";
    private static final String TERMINATE_SESSION = SESSION_STATE + "/terminate";
    private static final String SESSION_CAPABILITIES = HOST + "/sessionCapabilities";
    private static final String FIND_MATCHING_SESSION_HOST = HOST + "/findMatchingSession";
    private static final String WFSMBOX = HOST + "/wfsmbox";

    public SessionReservationDetails reserveSessions(SessionReservationDetails sessionReservationDetails) {
        Response post = (Response)RestAssured.given().header("Content-Type", (Object)"Application/json", new Object[0]).body((Object)sessionReservationDetails).post(RESERVE_SESSION, new Object[0]);
        return (SessionReservationDetails)post.as(SessionReservationDetails.class);
    }

    public void unReserveSession(String buildNo) {
        RestAssured.given().header("Content-Type", (Object)"Application/json", new Object[0]).queryParam("buildNo", new Object[]{buildNo}).post(UNRESERVE_SESSION, new Object[0]);
    }

    public SessionDetails getSessionDetails(MandatoryCaps mandatoryCaps) {
        Response matchingSessionDetails = (Response)RestAssured.given().header("Content-Type", (Object)"Application/json", new Object[0]).queryParam("platformName", new Object[]{mandatoryCaps.getPlatformName()}).queryParam("deviceType", new Object[]{mandatoryCaps.getDeviceType()}).queryParam("deviceName", new Object[]{mandatoryCaps.getDeviceName()}).queryParam("platformVersion", new Object[]{mandatoryCaps.getPlatformVersion()}).queryParam("udid", new Object[]{mandatoryCaps.getUdid()}).queryParam("buildNo", new Object[]{mandatoryCaps.getBuildNo()}).get(FIND_MATCHING_SESSION_HOST, new Object[0]);
        System.out.println("FindMatchingSessionHost=" + FIND_MATCHING_SESSION_HOST);
        System.out.println("Matching session Details" + matchingSessionDetails.asString());
        return (SessionDetails)matchingSessionDetails.as(SessionDetails.class);
    }

    public SessionState getCurrentSessionState(String sessionUrl) {
        Response sessionStateResponse = (Response)RestAssured.given().header("Content-Type", (Object)"Application/Json", new Object[0]).queryParam("sessionUrl", new Object[]{sessionUrl}).put(SESSION_CURRENT_STATE, new Object[0]);
        return (SessionState)((Object)sessionStateResponse.as(SessionState.class));
    }

    public void engageSession(String sessionUrl) {
        this.manageSession(sessionUrl, ENGAGE_SESSION);
    }

    public void releaseSession(String sessionUrl) {
        this.manageSession(sessionUrl, RELEASE_SESSION);
    }

    public void terminateSession(String sessionUrl) {
        this.manageSession(sessionUrl, TERMINATE_SESSION);
    }

    private void manageSession(String sessionUrl, String endpoint) {
        Response sessionStateResponse = (Response)RestAssured.given().header("Content-Type", (Object)"Application/Json", new Object[0]).queryParam("sessionUrl", new Object[]{sessionUrl}).put(endpoint, new Object[0]);
    }

    public LinkedHashMap<String, String> getSessionCapabilities(String sessionUrl) {
        Response sessionCapabilitiesResponse = (Response)RestAssured.given().header("Content-Type", (Object)"Application/Json", new Object[0]).queryParam("sessionUrl", new Object[]{sessionUrl}).get(SESSION_CAPABILITIES, new Object[0]);
        LinkedHashMap sessionCapabilitiesMap = (LinkedHashMap)sessionCapabilitiesResponse.as(LinkedHashMap.class);
        return sessionCapabilitiesMap;
    }

    public boolean isWfsmbox(String buildNo, String platform) {
        Response wfsmboxResp = (Response)RestAssured.given().header("Content-Type", (Object)"Application/Json", new Object[0]).queryParam("buildNo", new Object[]{buildNo}).queryParam("platform", new Object[]{platform}).get(WFSMBOX, new Object[0]);
        return (Boolean)wfsmboxResp.as(Boolean.class);
    }
}

