/*
 * Decompiled with CFR 0.152.
 */
package com.testquack.maven.mojo;

import com.testquack.beans.Launch;
import com.testquack.beans.LaunchStatus;
import com.testquack.beans.LaunchTestCase;
import com.testquack.beans.LaunchTestCaseTree;
import com.testquack.maven.client.QuackClient;
import com.testquack.maven.client.QuackClietnUtils;
import java.io.File;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.plugins.surefire.report.ReportTestCase;
import org.apache.maven.plugins.surefire.report.ReportTestSuite;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.reporting.MavenReportException;
import ru.greatbit.utils.string.StringUtils;

@Mojo(name="junit-results-import", requiresDependencyResolution=ResolutionScope.TEST, threadSafe=true, defaultPhase=LifecyclePhase.TEST)
public class QuackJunitResultsImport
extends AbstractMojo {
    @Parameter(property="junitXmlPath", defaultValue="${project.build.directory}/surefire-reports")
    File junitXmlResource;
    @Parameter(property="quackProject", name="quackProject", required=true)
    private String quackProject;
    @Parameter(property="apiToken", name="apiToken", required=true)
    private String apiToken;
    @Parameter(property="apiEndpoint", name="apiEndpoint", required=true)
    private String apiEndpoint;
    @Parameter(property="apiTimeout", name="apiTimeout", defaultValue="60000")
    private long apiTimeout;
    @Parameter(property="launchNamePrefix", name="launchNamePrefix", defaultValue="Junit Import")
    private String launchNamePrefix;
    private final Map<String, LaunchTestCase> testcasesByAlias = new HashMap<String, LaunchTestCase>();

    public void execute() throws MojoExecutionException, MojoFailureException {
        List testSuites;
        if (!this.junitXmlResource.isDirectory()) {
            throw new MojoExecutionException(this.junitXmlResource + " is not a directory");
        }
        this.getLog().debug((CharSequence)("Checking test results in " + this.junitXmlResource));
        List<File> reportDirectories = QuackJunitResultsImport.collectReportDirectoriesRecursively(this.junitXmlResource);
        SurefireReportParser parser = new SurefireReportParser(reportDirectories, Locale.getDefault());
        try {
            testSuites = parser.parseXMLReportFiles();
            this.getLog().info((CharSequence)("/////////////////// Got testsuites " + testSuites.stream().map(ReportTestSuite::getName)));
        }
        catch (MavenReportException e) {
            throw new MojoExecutionException("Could not parse XML reports", (Exception)((Object)e));
        }
        if (testSuites.isEmpty()) {
            this.getLog().warn((CharSequence)("XML reports not found in " + this.junitXmlResource));
        }
        testSuites.stream().flatMap(testSuite -> testSuite.getTestCases().stream()).filter(Objects::nonNull).forEach(reportTestCase -> {
            String alias = this.getAlias((ReportTestCase)reportTestCase);
            LaunchTestCase testCaseToStore = this.convertTestcase((ReportTestCase)reportTestCase);
            LaunchTestCase preservedTestcase = this.testcasesByAlias.get(alias);
            if (preservedTestcase == null || !this.isFailed(preservedTestcase) && this.isFailed(testCaseToStore)) {
                this.testcasesByAlias.put(alias, testCaseToStore);
            }
        });
        ArrayList<LaunchTestCase> launchTestCases = new ArrayList<LaunchTestCase>(this.testcasesByAlias.values());
        Launch launch = (Launch)new Launch().withName(this.launchNamePrefix + " " + new Date());
        launch.setTestCaseTree(new LaunchTestCaseTree().withTestCases(launchTestCases));
        this.getLog().info((CharSequence)"Starting launch import to QuAck");
        QuackClient client = QuackClietnUtils.getClient(this.apiToken, this.apiEndpoint, this.apiTimeout);
        try {
            client.createLaunch(this.quackProject, launch).execute();
        }
        catch (IOException e) {
            this.getLog().error((CharSequence)"Unable to import launch to QuAck", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isFailed(LaunchTestCase preservedTestcase) {
        return preservedTestcase.getLaunchStatus() == LaunchStatus.FAILED || preservedTestcase.getLaunchStatus() == LaunchStatus.BROKEN;
    }

    private String getAlias(ReportTestCase reportTestCase) {
        String fullNameNoParameters = reportTestCase.getFullName().split("\\[")[0];
        try {
            return StringUtils.getMd5String((String)fullNameNoParameters);
        }
        catch (NoSuchAlgorithmException e) {
            this.getLog().warn((CharSequence)"Unable to create testcase alias", (Throwable)e);
            return null;
        }
    }

    private LaunchTestCase convertTestcase(ReportTestCase reportTestCase) {
        this.getLog().info((CharSequence)("/////////////////// Converting report testcase " + reportTestCase.getFullName()));
        return (LaunchTestCase)new LaunchTestCase().withDuration(new Float(reportTestCase.getTime()).longValue()).withLaunchStatus(this.convertStatus(reportTestCase)).withFailureMessage(reportTestCase.getFailureMessage()).withFailureTrace(reportTestCase.getFailureDetail()).withAlias(this.getAlias(reportTestCase));
    }

    private LaunchStatus convertStatus(ReportTestCase reportTestCase) {
        if (reportTestCase.getFailureType() == null) {
            return LaunchStatus.PASSED;
        }
        switch (reportTestCase.getFailureType()) {
            case "skipped": {
                return LaunchStatus.SKIPPED;
            }
        }
        return LaunchStatus.FAILED;
    }

    static List<File> collectReportDirectoriesRecursively(File rootDirectory) throws MojoExecutionException {
        if (rootDirectory == null) {
            throw new MojoExecutionException("No valid directory provided");
        }
        if (!rootDirectory.exists()) {
            throw new MojoExecutionException("Directory " + rootDirectory + " does not exist");
        }
        if (!rootDirectory.isDirectory()) {
            throw new MojoExecutionException("Directory " + rootDirectory + " is no directory");
        }
        ArrayList<File> ret = new ArrayList<File>();
        ret.add(rootDirectory);
        for (File child : rootDirectory.listFiles()) {
            if (!child.isDirectory()) continue;
            ret.addAll(QuackJunitResultsImport.collectReportDirectoriesRecursively(child));
        }
        return ret;
    }

    private void logLines(List<String> lines) {
        for (String line : lines) {
            this.getLog().info((CharSequence)line);
        }
        this.getLog().info((CharSequence)"");
    }
}

