package com.testdroid.api.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.testdroid.api.APIEntity;

import javax.xml.bind.annotation.XmlRootElement;

/**
 * @author Michał Szpruta <michal.szpruta@bitbar.com>
 * @author Slawomir Pawluk <slawomir.pawluk@bitbar.com>
 */
@XmlRootElement
public class APIUserFileTag extends APIEntity {

    private String name;

    public APIUserFileTag() {
    }

    public APIUserFileTag(String name) {
        this.name = name;
    }

    public APIUserFileTag(Long id, String name) {
        super(id);
        this.name = name;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    @JsonIgnore
    protected <T extends APIEntity> void clone(T from) {
        APIUserFileTag apiUserFileTag = (APIUserFileTag) from;
        cloneBase(from);
        this.name = apiUserFileTag.name;
    }
}
