/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.logback;

import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.LoggingContext;
import com.tersesystems.echopraxia.logback.LogbackLoggerContext;
import com.tersesystems.echopraxia.spi.AbstractJsonPathFinder;
import com.tersesystems.echopraxia.spi.CoreLogger;
import com.tersesystems.echopraxia.spi.Utilities;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;

public class LogbackLoggingContext
extends AbstractJsonPathFinder
implements LoggingContext {
    private final Supplier<List<Field>> argumentFields;
    private final Supplier<List<Field>> loggerFields;
    private final LogbackLoggerContext loggerContext;
    private final Supplier<List<Field>> fields;
    private final CoreLogger core;

    public LogbackLoggingContext(CoreLogger core, LogbackLoggerContext loggerContext) {
        this(core, loggerContext, Collections::emptyList);
    }

    public LogbackLoggingContext(CoreLogger core, LogbackLoggerContext loggerContext, Supplier<List<Field>> arguments) {
        this.core = core;
        this.loggerContext = loggerContext;
        this.argumentFields = Utilities.memoize(arguments);
        this.loggerFields = Utilities.memoize(loggerContext::getLoggerFields);
        this.fields = Utilities.memoize((Supplier)Utilities.joinFields(this.loggerFields, this.argumentFields));
    }

    public CoreLogger getCore() {
        return this.core;
    }

    @NotNull
    public List<Field> getFields() {
        return this.fields.get();
    }

    public List<Field> getLoggerFields() {
        return this.loggerFields.get();
    }

    public List<Field> getArgumentFields() {
        return this.argumentFields.get();
    }

    public List<Marker> getMarkers() {
        return this.loggerContext.getMarkers();
    }
}

