/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.logback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.logback.AbstractEventLoggingContext;
import com.tersesystems.echopraxia.spi.CoreLogger;
import com.tersesystems.echopraxia.spi.Utilities;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;

public class FieldLoggingContext
extends AbstractEventLoggingContext {
    private final CoreLogger core;
    private final Supplier<List<Field>> argumentFields;
    private final Supplier<List<Field>> markerFields;
    private final Supplier<List<Field>> fields;

    public FieldLoggingContext(CoreLogger core, @NotNull ILoggingEvent event) {
        this.core = core;
        this.argumentFields = Utilities.memoize(() -> this.fieldArguments(event));
        this.markerFields = Utilities.memoize(() -> this.fieldMarkers(event));
        this.fields = Utilities.memoize(() -> {
            ArrayList<Field> fields = new ArrayList<Field>();
            fields.addAll(this.getArgumentFields());
            fields.addAll(this.getLoggerFields());
            return fields;
        });
    }

    public CoreLogger getCore() {
        return this.core;
    }

    @NotNull
    public List<Field> getFields() {
        return this.fields.get();
    }

    @NotNull
    public List<Field> getLoggerFields() {
        return this.markerFields.get();
    }

    @NotNull
    public List<Field> getArgumentFields() {
        return this.argumentFields.get();
    }
}

