/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.spi;

import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public final class Utilities {
    @NotNull
    public static Function<Supplier<Map<String, String>>, Supplier<List<Field>>> getThreadContextFunction(@NotNull Function<Map<String, String>, List<Field>> f) {
        return mapSupplier -> () -> Utilities.lambda$getThreadContextFunction$0(f, (Supplier)mapSupplier);
    }

    @NotNull
    public static <T> Supplier<T> memoize(@NotNull Supplier<T> supplier) {
        return new MemoizingSupplier<T>(supplier);
    }

    @NotNull
    public static List<Field> buildThreadContext(Map<String, String> contextMap) {
        if (contextMap == null || contextMap.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Field> list = new ArrayList<Field>();
        for (Map.Entry<String, String> e : contextMap.entrySet()) {
            Field field = Field.keyValue(e.getKey(), Value.string(e.getValue()));
            list.add(field);
        }
        return list;
    }

    public static Supplier<List<Field>> joinFields(Supplier<List<Field>> first, Supplier<List<Field>> second) {
        return () -> {
            List firstFields = (List)first.get();
            List secondFields = (List)second.get();
            if (firstFields.isEmpty()) {
                return secondFields;
            }
            if (secondFields.isEmpty()) {
                return firstFields;
            }
            return Stream.concat(firstFields.stream(), secondFields.stream()).collect(Collectors.toList());
        };
    }

    @NotNull
    public static Function<Supplier<Map<String, String>>, Supplier<List<Field>>> threadContext() {
        return Utilities.getThreadContextFunction(Utilities::buildThreadContext);
    }

    private static /* synthetic */ List lambda$getThreadContextFunction$0(Function f, Supplier mapSupplier) {
        return (List)f.apply((Map)mapSupplier.get());
    }

    @NotNull
    static class MemoizingSupplier<T>
    implements Supplier<T> {
        final Supplier<T> delegate;
        volatile transient boolean initialized;
        transient T value;

        MemoizingSupplier(Supplier<T> delegate) {
            this.delegate = delegate;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T get() {
            if (!this.initialized) {
                MemoizingSupplier memoizingSupplier = this;
                synchronized (memoizingSupplier) {
                    if (!this.initialized) {
                        T t = this.delegate.get();
                        this.value = t;
                        this.initialized = true;
                        return t;
                    }
                }
            }
            return this.value;
        }
    }
}

