/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.spi;

import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPathException;
import com.jayway.jsonpath.TypeRef;
import com.jayway.jsonpath.spi.mapper.MappingException;
import com.jayway.jsonpath.spi.mapper.MappingProvider;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.spi.FieldConstants;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EchopraxiaMappingProvider
implements MappingProvider {
    public <T> T map(@Nullable Object source, @NotNull Class<T> targetType, Configuration configuration) {
        if (source == null) {
            return null;
        }
        if (targetType.equals(Object.class) || targetType.equals(List.class) || targetType.equals(Map.class)) {
            return (T)this.mapToObject(source);
        }
        if (targetType.equals(String.class) || Number.class.isAssignableFrom(targetType) || targetType.equals(Boolean.class) || targetType.equals(Throwable.class)) {
            return this.mapToValue(source);
        }
        return (T)source;
    }

    @Nullable
    private <T> T mapToValue(@Nullable Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof Value) {
            Value value = (Value)source;
            switch (value.type()) {
                case STRING: 
                case EXCEPTION: 
                case BOOLEAN: 
                case NUMBER: {
                    return (T)value.raw();
                }
                case NULL: {
                    return null;
                }
            }
            throw new JsonPathException("No match for value " + value);
        }
        return (T)source;
    }

    public <T> T map(Object source, TypeRef<T> targetType, Configuration configuration) {
        try {
            String msg = "TypeRef are not supported, source = " + source + " targetType = " + targetType;
            throw new UnsupportedOperationException(msg);
        }
        catch (Exception e) {
            throw new MappingException((Throwable)e);
        }
    }

    @Nullable
    private Object mapToObject(@Nullable Object source) {
        if (source == null) {
            return null;
        }
        if (source == Value.NullValue.instance) {
            return null;
        }
        if (source instanceof List) {
            return this.getList((List)source);
        }
        if (source instanceof Map) {
            return this.getMap((Map)source);
        }
        if (source instanceof Value.ArrayValue) {
            return this.getArrayValue((Value.ArrayValue)source);
        }
        if (source instanceof Value.ObjectValue) {
            return this.getObjectValue((Value.ObjectValue)source);
        }
        if (source instanceof Value) {
            return ((Value)source).raw();
        }
        if (source instanceof StackTraceElement[]) {
            return this.getStackTraceElements((StackTraceElement[])source);
        }
        if (source instanceof StackTraceElement) {
            return this.getStackTraceElement((StackTraceElement)source);
        }
        throw new JsonPathException("Could not determine value type for " + source.getClass());
    }

    @NotNull
    private Map<String, Object> getStackTraceElement(StackTraceElement source) {
        HashMap<String, Object> elementMap = new HashMap<String, Object>(8);
        elementMap.put(FieldConstants.METHOD_NAME, source.getMethodName());
        elementMap.put(FieldConstants.CLASS_NAME, source.getClassName());
        elementMap.put(FieldConstants.FILE_NAME, source.getFileName());
        elementMap.put(FieldConstants.LINE_NUMBER, source.getLineNumber());
        return elementMap;
    }

    @NotNull
    private List<Object> getStackTraceElements(StackTraceElement[] source) {
        ArrayList<Object> mapped = new ArrayList<Object>(source.length);
        for (StackTraceElement value : source) {
            mapped.add(this.mapToObject(value));
        }
        return mapped;
    }

    @NotNull
    private Map<String, Object> getObjectValue(Value.ObjectValue source) {
        HashMap<String, Object> mapped = new HashMap<String, Object>();
        Object raw = source.raw();
        Iterator iterator = raw.iterator();
        while (iterator.hasNext()) {
            Field f = (Field)iterator.next();
            mapped.put(f.name(), this.mapToObject(f.value()));
        }
        return mapped;
    }

    @NotNull
    private List<Object> getArrayValue(Value.ArrayValue source) {
        Object array = source.raw();
        ArrayList<Object> mapped = new ArrayList<Object>(array.size());
        Iterator iterator = array.iterator();
        while (iterator.hasNext()) {
            Value value = (Value)iterator.next();
            mapped.add(this.mapToObject(value));
        }
        return mapped;
    }

    @NotNull
    private Map<String, Object> getMap(Map<String, ?> source) {
        HashMap<String, Object> mapped = new HashMap<String, Object>();
        for (String key : source.keySet()) {
            Object mapValue = source.get(key);
            mapped.put(key, this.mapToObject(mapValue));
        }
        return mapped;
    }

    @NotNull
    private List<Object> getList(List<?> source) {
        ArrayList<Object> mapped = new ArrayList<Object>(source.size());
        for (Object value : source) {
            mapped.add(this.mapToObject(value));
        }
        return mapped;
    }
}

