/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.spi;

import com.tersesystems.echopraxia.api.Attribute;
import com.tersesystems.echopraxia.api.AttributeKey;
import com.tersesystems.echopraxia.api.Attributes;
import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.api.FieldVisitor;
import com.tersesystems.echopraxia.api.PresentationField;
import com.tersesystems.echopraxia.api.Value;
import com.tersesystems.echopraxia.spi.EchopraxiaService;
import com.tersesystems.echopraxia.spi.PresentationHintAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class DefaultField
implements PresentationField {
    protected final String name;
    protected final Value<?> value;
    protected final Attributes attributes;

    protected DefaultField(@NotNull String name, @NotNull Value<?> value, @NotNull Attributes attributes) {
        this.name = Field.requireName(name);
        this.value = Field.requireValue(value);
        this.attributes = attributes;
    }

    @Override
    @NotNull
    public DefaultField asValueOnly() {
        return this.withAttribute((Attribute)PresentationHintAttributes.asValueOnly());
    }

    @Override
    @NotNull
    public DefaultField abbreviateAfter(int after) {
        return this.withAttribute((Attribute)PresentationHintAttributes.abbreviateAfter(after));
    }

    @Override
    @NotNull
    public DefaultField asCardinal() {
        return this.withAttribute((Attribute)PresentationHintAttributes.asCardinal());
    }

    @Override
    @NotNull
    public DefaultField asElided() {
        return this.withAttribute((Attribute)PresentationHintAttributes.asElided());
    }

    @Override
    @NotNull
    public DefaultField withDisplayName(@NotNull String displayName) {
        return this.withAttribute((Attribute)PresentationHintAttributes.withDisplayName(displayName));
    }

    @Override
    @NotNull
    public DefaultField withStructuredFormat(@NotNull FieldVisitor fieldVisitor) {
        return this.withAttribute((Attribute)PresentationHintAttributes.withStructuredFormat(fieldVisitor));
    }

    @Override
    @NotNull
    public <A> DefaultField withAttribute(@NotNull Attribute<A> attr) {
        return this.newAttributes(this.attributes.plus(attr));
    }

    @Override
    @NotNull
    public DefaultField withAttributes(@NotNull Attributes attrs) {
        return this.newAttributes(this.attributes.plusAll(attrs));
    }

    @Override
    @NotNull
    public <A> DefaultField withoutAttribute(@NotNull AttributeKey<A> key) {
        return this.newAttributes(this.attributes.minus(key));
    }

    @Override
    @NotNull
    public DefaultField withoutAttributes(@NotNull Collection<AttributeKey<?>> keys) {
        return this.newAttributes(this.attributes.minusAll(keys));
    }

    @Override
    @NotNull
    public DefaultField clearAttributes() {
        return this.newAttributes(Attributes.empty());
    }

    @Override
    @NotNull
    public String name() {
        return this.name;
    }

    @Override
    @NotNull
    public Value<?> value() {
        return this.value;
    }

    @Override
    @NotNull
    public Attributes attributes() {
        return this.attributes;
    }

    @Override
    @NotNull
    public List<Field> fields() {
        return Collections.singletonList(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultField that = (DefaultField)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.value, that.value) && Objects.equals(this.attributes, that.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.value, this.attributes);
    }

    public String toString() {
        return EchopraxiaService.getInstance().getToStringFormatter().formatField(this);
    }

    @NotNull
    private DefaultField newAttributes(@NotNull Attributes attrs) {
        return new DefaultField(this.name, this.value, attrs);
    }
}

