/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.spi;

import com.tersesystems.echopraxia.api.Condition;
import com.tersesystems.echopraxia.api.FieldBuilderResult;
import com.tersesystems.echopraxia.spi.CoreLogger;
import com.tersesystems.echopraxia.spi.DefaultMethodsSupport;
import com.tersesystems.echopraxia.spi.Utilities;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractLoggerSupport<SELF extends AbstractLoggerSupport<SELF, FB>, FB>
implements DefaultMethodsSupport<FB> {
    protected final CoreLogger core;
    protected final FB fieldBuilder;
    private final SELF myself;

    protected AbstractLoggerSupport(@NotNull CoreLogger core, @NotNull FB fieldBuilder, @NotNull Class<?> selfType) {
        this.myself = (AbstractLoggerSupport)selfType.cast(this);
        this.core = core;
        this.fieldBuilder = fieldBuilder;
    }

    @Override
    @NotNull
    public String getName() {
        return this.core.getName();
    }

    @Override
    @NotNull
    public CoreLogger core() {
        return this.core;
    }

    @Override
    @NotNull
    public FB fieldBuilder() {
        return this.fieldBuilder;
    }

    @NotNull
    public SELF withCondition(@NotNull Condition condition) {
        if (condition == Condition.always()) {
            return this.self();
        }
        if (condition == Condition.never()) {
            return this.neverLogger();
        }
        return this.newLogger(this.core().withCondition(condition));
    }

    @NotNull
    public SELF withFields(@NotNull Function<FB, FieldBuilderResult> f) {
        return this.newLogger(this.core().withFields(f, this.fieldBuilder));
    }

    @NotNull
    public SELF withThreadContext() {
        return this.newLogger(this.core().withThreadContext(Utilities.threadContext()));
    }

    @NotNull
    protected abstract SELF newLogger(CoreLogger var1);

    @NotNull
    protected abstract SELF neverLogger();

    protected SELF self() {
        return this.myself;
    }
}

