/*
 * Decompiled with CFR 0.152.
 */
package com.tersesystems.echopraxia.api;

import com.tersesystems.echopraxia.api.Field;
import com.tersesystems.echopraxia.spi.EchopraxiaService;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;

public abstract class Value<V> {
    protected Value() {
    }

    public abstract V raw();

    @NotNull
    public abstract Type type();

    @NotNull
    public ObjectValue asObject() {
        return (ObjectValue)this;
    }

    @NotNull
    public ArrayValue asArray() {
        return (ArrayValue)this;
    }

    @NotNull
    public StringValue asString() {
        return (StringValue)this;
    }

    @NotNull
    public <T extends Number> NumberValue<T> asNumber() {
        return (NumberValue)this;
    }

    public ExceptionValue asException() {
        return (ExceptionValue)this;
    }

    public NullValue asNull() {
        return (NullValue)this;
    }

    public BooleanValue asBoolean() {
        return (BooleanValue)this;
    }

    @NotNull
    public String toString() {
        return EchopraxiaService.getInstance().getToStringFormatter().formatValue(this);
    }

    @NotNull
    public static StringValue string(@NotNull String value) {
        return new StringValue(value);
    }

    @NotNull
    public static Value<Byte> number(@NotNull Byte value) {
        int offset = 128;
        if (value == null) {
            return NumberValue.ByteValue.Cache.cache[128];
        }
        return NumberValue.ByteValue.Cache.cache[value + 128];
    }

    @NotNull
    public static Value<Short> number(@NotNull Short s) {
        if (s == null) {
            return NumberValue.ShortValue.ZERO;
        }
        int offset = 128;
        short sAsInt = s;
        if (sAsInt >= -128 && sAsInt <= 127) {
            return NumberValue.ShortValue.Cache.cache[sAsInt + 128];
        }
        return new NumberValue.ShortValue(s);
    }

    @NotNull
    public static NumberValue<Integer> number(@NotNull Integer value) {
        if (value == null) {
            return NumberValue.IntegerValue.Cache.cache[128];
        }
        if (value >= -128 && value <= 127) {
            return NumberValue.IntegerValue.Cache.cache[value + 128];
        }
        return new NumberValue.IntegerValue(value);
    }

    public static NumberValue<Long> number(@NotNull Long value) {
        int offset = 128;
        if (value == null) {
            return NumberValue.LongValue.Cache.cache[128];
        }
        if (value >= -128L && value <= 127L) {
            return NumberValue.LongValue.Cache.cache[value.intValue() + 128];
        }
        return new NumberValue.LongValue(value);
    }

    public static NumberValue<Float> number(@NotNull Float value) {
        if (value == null || Objects.equals(value, Float.valueOf(0.0f))) {
            return NumberValue.FloatValue.ZERO;
        }
        return new NumberValue.FloatValue(value);
    }

    public static NumberValue<Double> number(@NotNull Double value) {
        if (value == null || Objects.equals(value, 0.0)) {
            return NumberValue.DoubleValue.ZERO;
        }
        return new NumberValue.DoubleValue(value);
    }

    public static NumberValue<BigInteger> number(@NotNull BigInteger value) {
        if (value == null || Objects.equals(value, BigInteger.ZERO)) {
            return NumberValue.BigIntegerValue.ZERO;
        }
        return new NumberValue.BigIntegerValue(value);
    }

    public static NumberValue<BigDecimal> number(@NotNull BigDecimal value) {
        if (value == null || Objects.equals(value, BigDecimal.ZERO)) {
            return NumberValue.BigDecimalValue.ZERO;
        }
        return new NumberValue.BigDecimalValue(value);
    }

    @NotNull
    public static BooleanValue bool(@NotNull Boolean value) {
        if (value == null) {
            return BooleanValue.FALSE;
        }
        return value != false ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    @NotNull
    public static Value<?> nullValue() {
        return NullValue.instance;
    }

    @NotNull
    public static ExceptionValue exception(@NotNull Throwable t) {
        return new ExceptionValue(t);
    }

    @NotNull
    public static ArrayValue array(Value<?> ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Arrays.asList(values));
    }

    @NotNull
    public static ArrayValue array(Boolean ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, Value::bool));
    }

    @NotNull
    public static ArrayValue array(String ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, Value::string));
    }

    @NotNull
    public static ArrayValue array(Byte ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, Value::number));
    }

    public static ArrayValue array(Short ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, Value::number));
    }

    public static ArrayValue array(Integer ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, Value::number));
    }

    public static ArrayValue array(Long ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, Value::number));
    }

    public static ArrayValue array(Double ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, Value::number));
    }

    public static ArrayValue array(Float ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, Value::number));
    }

    public static ArrayValue array(BigInteger ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, Value::number));
    }

    public static ArrayValue array(BigDecimal ... values) {
        if (values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, Value::number));
    }

    public static ArrayValue array(@NotNull List<Value<?>> values) {
        if (values == null || values.size() == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(values);
    }

    @NotNull
    public static <T> ArrayValue array(@NotNull Function<T, Value<?>> transform, @NotNull List<T> values) {
        if (values == null || values.size() == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, transform));
    }

    @NotNull
    public static <T> ArrayValue array(@NotNull Function<T, Value<?>> transform, T @NotNull [] values) {
        if (values == null || values.length == 0) {
            return ArrayValue.EMPTY;
        }
        return new ArrayValue(Value.asList(values, transform));
    }

    @NotNull
    public static ObjectValue object(Field ... fields) {
        if (fields.length == 0) {
            return ObjectValue.EMPTY;
        }
        List nonNullList = Arrays.stream(fields).filter(Objects::nonNull).collect(Collectors.toList());
        return new ObjectValue(nonNullList);
    }

    @NotNull
    public static ObjectValue object(@NotNull List<? extends Field> fields) {
        if (fields == null || fields.size() == 0) {
            return ObjectValue.EMPTY;
        }
        ArrayList<Field> nonNullList = new ArrayList<Field>(fields.size());
        for (Field field : fields) {
            if (field == null) continue;
            nonNullList.add(field);
        }
        return new ObjectValue(nonNullList);
    }

    @NotNull
    public static <T> ObjectValue object(@NotNull Function<T, Field> transform, T @NotNull [] values) {
        if (values == null || values.length == 0) {
            return ObjectValue.EMPTY;
        }
        List fields = Arrays.stream(values).map(transform).filter(Objects::nonNull).collect(Collectors.toList());
        return new ObjectValue(fields);
    }

    @NotNull
    public static <T> ObjectValue object(@NotNull Function<T, Field> transform, @NotNull List<T> values) {
        if (values == null || values.size() == 0) {
            return ObjectValue.EMPTY;
        }
        ArrayList<Field> fields = new ArrayList<Field>(values.size());
        for (T value : values) {
            Field field = transform.apply(value);
            if (field == null) continue;
            fields.add(field);
        }
        return new ObjectValue(fields);
    }

    @NotNull
    public static Value<?> optional(@NotNull Optional<? extends Value<?>> optionalValue) {
        if (optionalValue != null && optionalValue.isPresent()) {
            return optionalValue.get();
        }
        return Value.nullValue();
    }

    public static <T> boolean equals(Value<? extends T> value1, Value<? extends T> value2) {
        return Objects.equals(value1, value2);
    }

    @NotNull
    private static <T> List<Value<?>> asList(T @NotNull [] array, @NotNull Function<T, Value<?>> f) {
        return Arrays.stream(array).map(f).collect(Collectors.toList());
    }

    @NotNull
    private static <T> List<Value<?>> asList(@NotNull List<T> values, @NotNull Function<T, Value<?>> f) {
        ArrayList list = new ArrayList(values.size());
        for (T value : values) {
            Value<?> value1 = f.apply(value);
            list.add(value1);
        }
        return list;
    }

    public static final class ObjectValue
    extends Value<List<Field>> {
        public static final ObjectValue EMPTY = new ObjectValue(Collections.emptyList());
        private final List<Field> raw;

        private ObjectValue(List<Field> raw) {
            this.raw = raw;
        }

        @Override
        @NotNull
        public Type type() {
            return Type.OBJECT;
        }

        @Override
        public List<Field> raw() {
            return this.raw;
        }

        public ObjectValue add(Field field) {
            ArrayList<Field> fields = new ArrayList<Field>(this.raw);
            fields.add(field);
            return new ObjectValue(fields);
        }

        public ObjectValue addAll(Collection<Field> fields) {
            ArrayList<Field> joinedFields = new ArrayList<Field>(this.raw);
            joinedFields.addAll(fields);
            return new ObjectValue(joinedFields);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ObjectValue that = (ObjectValue)o;
            return Objects.equals(this.raw, that.raw);
        }

        public int hashCode() {
            return this.raw != null ? this.raw.hashCode() : 0;
        }
    }

    public static final class ArrayValue
    extends Value<List<Value<?>>> {
        private final List<Value<?>> raw;
        public static final ArrayValue EMPTY = new ArrayValue(Collections.emptyList());

        private ArrayValue(List<Value<?>> raw) {
            this.raw = raw;
        }

        @Override
        @NotNull
        public List<Value<?>> raw() {
            return this.raw;
        }

        @Override
        @NotNull
        public Type type() {
            return Type.ARRAY;
        }

        public ArrayValue add(Value<?> value) {
            ArrayList values = new ArrayList(this.raw);
            values.add(value);
            return new ArrayValue(values);
        }

        public ArrayValue addAll(Collection<Value<?>> values) {
            ArrayList joinedValues = new ArrayList(this.raw);
            joinedValues.addAll(values);
            return new ArrayValue(joinedValues);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ArrayValue that = (ArrayValue)o;
            return Objects.equals(this.raw, that.raw);
        }

        public int hashCode() {
            return this.raw != null ? this.raw.hashCode() : 0;
        }
    }

    public static final class StringValue
    extends Value<String>
    implements Comparable<StringValue> {
        private final String raw;

        private StringValue(String s) {
            this.raw = s;
        }

        @Override
        public String raw() {
            return this.raw;
        }

        @Override
        @NotNull
        public Type type() {
            return Type.STRING;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StringValue that = (StringValue)o;
            return Objects.equals(this.raw, that.raw);
        }

        public int hashCode() {
            return this.raw != null ? this.raw.hashCode() : 0;
        }

        @Override
        public int compareTo(@NotNull StringValue o) {
            return o.raw.compareTo(this.raw);
        }
    }

    public static class NumberValue<N extends Number>
    extends Value<N>
    implements Comparable<NumberValue<N>> {
        private final N raw;

        private NumberValue(N number) {
            this.raw = number;
        }

        @Override
        public N raw() {
            return this.raw;
        }

        @Override
        @NotNull
        public Type type() {
            return Type.NUMBER;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NumberValue that = (NumberValue)o;
            return Objects.equals(this.raw, that.raw);
        }

        public int hashCode() {
            return this.raw != null ? this.raw.hashCode() : 0;
        }

        @Override
        public int compareTo(@NotNull NumberValue<N> o) {
            return ((Comparable)this.raw).compareTo(o.raw);
        }

        /* synthetic */ NumberValue(Number x0, 1 x1) {
            this(x0);
        }

        private static final class BigDecimalValue
        extends NumberValue<BigDecimal> {
            public static final BigDecimalValue ZERO = new BigDecimalValue(BigDecimal.ZERO);

            private BigDecimalValue(BigDecimal number) {
                super(number, null);
            }
        }

        private static final class BigIntegerValue
        extends NumberValue<BigInteger> {
            public static final BigIntegerValue ZERO = new BigIntegerValue(BigInteger.ZERO);

            private BigIntegerValue(BigInteger number) {
                super(number, null);
            }
        }

        private static final class FloatValue
        extends NumberValue<Float> {
            public static final FloatValue ZERO = new FloatValue(Float.valueOf(0.0f));

            private FloatValue(Float number) {
                super(number, null);
            }
        }

        private static final class DoubleValue
        extends NumberValue<Double> {
            public static final DoubleValue ZERO = new DoubleValue(0.0);

            private DoubleValue(Double number) {
                super(number, null);
            }
        }

        private static final class LongValue
        extends NumberValue<Long> {
            private LongValue(Long number) {
                super(number, null);
            }

            private static class Cache {
                static final LongValue[] cache = new LongValue[256];

                private Cache() {
                }

                static {
                    for (int i = 0; i < cache.length; ++i) {
                        Cache.cache[i] = new LongValue(Long.valueOf(i - 128));
                    }
                }
            }
        }

        private static final class IntegerValue
        extends NumberValue<Integer> {
            private IntegerValue(Integer number) {
                super(number, null);
            }

            private static class Cache {
                static final int low = -128;
                static final int high = 127;
                static final IntegerValue[] cache = new IntegerValue[256];

                private Cache() {
                }

                static {
                    for (int i = 0; i < cache.length; ++i) {
                        Cache.cache[i] = new IntegerValue(i - 128);
                    }
                }
            }
        }

        private static final class ShortValue
        extends NumberValue<Short> {
            public static final ShortValue ZERO = new ShortValue((short)0);

            private ShortValue(Short number) {
                super(number, null);
            }

            private static class Cache {
                static final ShortValue[] cache = new ShortValue[256];

                private Cache() {
                }

                static {
                    for (int i = 0; i < cache.length; ++i) {
                        Cache.cache[i] = new ShortValue((short)(i - 128));
                    }
                }
            }
        }

        private static final class ByteValue
        extends NumberValue<Byte> {
            private ByteValue(Byte number) {
                super(number, null);
            }

            private static class Cache {
                static final ByteValue[] cache = new ByteValue[256];

                private Cache() {
                }

                static {
                    for (int i = 0; i < cache.length; ++i) {
                        Cache.cache[i] = new ByteValue((byte)(i - 128));
                    }
                }
            }
        }
    }

    public static final class ExceptionValue
    extends Value<Throwable> {
        private final Throwable raw;

        private ExceptionValue(Throwable raw) {
            this.raw = raw;
        }

        @Override
        @NotNull
        public Type type() {
            return Type.EXCEPTION;
        }

        @Override
        public Throwable raw() {
            return this.raw;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExceptionValue that = (ExceptionValue)o;
            return Objects.equals(this.raw, that.raw);
        }

        public int hashCode() {
            return this.raw != null ? this.raw.hashCode() : 0;
        }
    }

    public static final class NullValue
    extends Value<Void> {
        @NotNull
        public static final NullValue instance = new NullValue();

        private NullValue() {
        }

        @Override
        public Void raw() {
            return null;
        }

        @Override
        @NotNull
        public Type type() {
            return Type.NULL;
        }
    }

    public static final class BooleanValue
    extends Value<Boolean> {
        public static final BooleanValue TRUE = new BooleanValue(true);
        public static final BooleanValue FALSE = new BooleanValue(false);
        private final Boolean raw;

        private BooleanValue(Boolean bool) {
            this.raw = bool;
        }

        @Override
        @NotNull
        public Boolean raw() {
            return this.raw;
        }

        @Override
        @NotNull
        public Type type() {
            return Type.BOOLEAN;
        }
    }

    public static enum Type {
        ARRAY,
        OBJECT,
        STRING,
        NUMBER,
        BOOLEAN,
        EXCEPTION,
        NULL;

    }
}

